/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.EventListenerService;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.core.WorkflowDataAccessor;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventListenerManager;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEventNotifier;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.instance.EventLog;

public class EventListenerServiceImpl
implements EventListenerService {
    private WorkflowDataAccessor workflowDataAccessor;
    private WorkflowContextBuilder workflowContextBuilder;
    private WorkflowEventNotifier workflowEventNotifier;
    private WorkflowEventListenerManager workflowEventListenerManager;

    public EventListenerServiceImpl(WorkflowDataAccessor workflowDataAccessor, WorkflowContextBuilder workflowContextBuilder, WorkflowEventNotifier workflowEventNotifier, WorkflowEventListenerManager workflowEventListenerManager) {
        this.workflowDataAccessor = workflowDataAccessor;
        this.workflowContextBuilder = workflowContextBuilder;
        this.workflowEventNotifier = workflowEventNotifier;
        this.workflowEventListenerManager = workflowEventListenerManager;
    }

    @Override
    public void executeEventListener(Integer eventLogId) {
        EventLog eventLog = this.workflowDataAccessor.eventLogStorage().get(eventLogId);
        Preconditions.checkNotNull((Object)eventLog, () -> "event log not exist with id:" + eventLogId);
        if (ProcessEvent.class.getSimpleName().equals(eventLog.getEventType())) {
            this.executeProcessEventListener(eventLog.getProcessInstId(), eventLog.getListener());
            return;
        }
        if (TaskEvent.class.getSimpleName().equals(eventLog.getEventType())) {
            this.executeTaskEventListener(eventLog.getTaskInstId(), eventLog.getListener());
            return;
        }
        throw new WorkflowException("unknow event type:" + eventLog.getEventType());
    }

    @Override
    public void executeProcessEventListener(Integer processInstId, String listenerName) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(processInstId);
        ProcessEvent processEvent = (ProcessEvent)this.getProcessEventListener(context.getProcess(), listenerName).event();
        context.setCurrentElement(this.getCurrentElementForProcess(context.getProcess(), processEvent));
        this.workflowEventNotifier.getProcessEventNotifier().notify(listenerName, true, context);
    }

    @Override
    public void executeTaskEventListener(Integer taskInstId, String listenerName) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskInstId, null);
        TaskEventListener taskEventListener = this.getTaskEventListener((Task)context.getCurrentElement(), listenerName);
        context.getActionContext().setAction(Action.fromTaskEvent((TaskEvent)taskEventListener.event()));
        this.workflowEventNotifier.getTaskEventNotifier().notify(listenerName, true, context);
    }

    @Override
    public void triggerProcessEvent(Integer processInstId, ProcessEvent processEvent) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(processInstId);
        context.setCurrentElement(this.getCurrentElementForProcess(context.getProcess(), processEvent));
        this.workflowEventNotifier.getProcessEventNotifier().notify(processEvent, context);
    }

    @Override
    public void triggerTaskEvent(Integer taskInstId, TaskEvent taskEvent) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskInstId, Action.fromTaskEvent(taskEvent));
        this.workflowEventNotifier.getTaskEventNotifier().notify(taskEvent, context);
    }

    private Element getCurrentElementForProcess(Process process, ProcessEvent processEvent) {
        if (ProcessEvent.CREATE.equals(processEvent)) {
            return process.getStartEvent();
        }
        return process.getEndEvent();
    }

    private ProcessEventListener getProcessEventListener(Process process, String listenerName) {
        ProcessEventListener listener = process.listener(listenerName);
        if (listener != null) {
            return listener;
        }
        listener = this.workflowEventListenerManager.getProcessEventListenerManager().listener(listenerName);
        Preconditions.checkNotNull((Object)listener, (String)("process listener not exist:" + listenerName));
        return listener;
    }

    private TaskEventListener getTaskEventListener(Task task, String listenerName) {
        TaskEventListener listener = task.listener(listenerName);
        if (listener != null) {
            return listener;
        }
        listener = this.workflowEventListenerManager.getTaskEventListenerManager().listener(listenerName);
        Preconditions.checkNotNull((Object)listener, (String)("task listener not exist:" + listenerName));
        return listener;
    }
}

