/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.event.process;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.inlong.manager.workflow.core.event.EventListenerManager;
import org.apache.inlong.manager.workflow.core.event.EventListenerNotifier;
import org.apache.inlong.manager.workflow.core.event.LogableEventListener;
import org.apache.inlong.manager.workflow.core.event.process.LogableProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListenerManager;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEventNotifier
implements EventListenerNotifier<ProcessEvent> {
    private static final Logger log = LoggerFactory.getLogger(ProcessEventNotifier.class);
    private final ExecutorService executorService = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("async-process-event-notifier-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    private EventListenerManager<ProcessEvent, ProcessEventListener> eventListenerManager;

    public ProcessEventNotifier(ProcessEventListenerManager eventListenerManager) {
        this.eventListenerManager = eventListenerManager;
    }

    @Override
    public void notify(ProcessEvent event, WorkflowContext sourceContext) {
        WorkflowContext context = sourceContext.clone();
        Process process = context.getProcess();
        this.eventListenerManager.syncListeners(event).forEach(this.syncLogableNotify(context));
        process.syncListeners(event).forEach(this.syncLogableNotify(context));
        this.eventListenerManager.asyncListeners(event).forEach(this.asyncLogableNotify(context));
        process.asyncListeners(event).forEach(this.asyncLogableNotify(context));
    }

    @Override
    public void notify(String listenerName, boolean forceSync, WorkflowContext sourceContext) {
        WorkflowContext context = sourceContext.clone();
        Process process = context.getProcess();
        Optional.ofNullable(this.eventListenerManager.listener(listenerName)).ifPresent(this.logableNotify(forceSync, context));
        Optional.ofNullable(process.listener(listenerName)).ifPresent(this.logableNotify(forceSync, context));
    }

    private Consumer<ProcessEventListener> logableNotify(boolean forceSync, WorkflowContext context) {
        return listener -> {
            if (forceSync || !listener.async()) {
                this.syncLogableNotify(context).accept((ProcessEventListener)listener);
                return;
            }
            this.asyncLogableNotify(context).accept((ProcessEventListener)listener);
        };
    }

    private Consumer<ProcessEventListener> asyncLogableNotify(WorkflowContext context) {
        return listener -> this.executorService.execute(() -> this.logableEventListener((ProcessEventListener)listener).listen(context));
    }

    private Consumer<ProcessEventListener> syncLogableNotify(WorkflowContext context) {
        return listener -> this.logableEventListener((ProcessEventListener)listener).listen(context);
    }

    private LogableProcessEventListener logableEventListener(ProcessEventListener listener) {
        if (listener instanceof LogableEventListener) {
            return (LogableProcessEventListener)listener;
        }
        return new LogableProcessEventListener(listener, this.eventListenerManager.eventLogStorage());
    }
}

