/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.event;

import java.util.Date;
import java.util.Optional;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.NetworkUtils;
import org.apache.inlong.manager.workflow.core.event.EventListener;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.WorkflowEvent;
import org.apache.inlong.manager.workflow.dao.EventLogStorage;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.EventState;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.instance.EventLog;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogableEventListener<EventType extends WorkflowEvent>
implements EventListener<EventType> {
    private static final Logger log = LoggerFactory.getLogger(LogableEventListener.class);
    private EventListener<EventType> eventListener;
    private EventLogStorage eventLogStorage;

    public LogableEventListener(EventListener<EventType> eventListener, EventLogStorage eventLogStorage) {
        this.eventListener = eventListener;
        this.eventLogStorage = eventLogStorage;
    }

    @Override
    public EventType event() {
        return this.eventListener.event();
    }

    @Override
    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        if (this.eventListener.ignoreRecordLog()) {
            return this.executeListenerWithoutLog(context);
        }
        return this.executeListenerWithLog(context);
    }

    private ListenerResult executeListenerWithoutLog(WorkflowContext context) {
        EventLog eventLog = this.buildEventLog(context);
        try {
            ListenerResult result = this.eventListener.listen(context);
            log.debug("listener execute result:{} - {}", (Object)eventLog, (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("listener exception:{}", (Object)eventLog, (Object)e);
            if (!this.async()) {
                throw new WorkflowListenerException(e);
            }
            return ListenerResult.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerResult executeListenerWithLog(WorkflowContext context) {
        ListenerResult result;
        EventLog eventLog = this.buildEventLog(context);
        try {
            result = this.eventListener.listen(context);
            eventLog.setState(result.isSuccess() ? EventState.SUCCESS.getState() : EventState.FAILED.getState());
            eventLog.setRemark(result.getRemark());
            eventLog.setException(Optional.ofNullable(result.getException()).map(Throwable::getMessage).orElse(null));
        }
        catch (Exception e) {
            eventLog.setState(EventState.FAILED.getState());
            eventLog.setException(e.getMessage());
            log.error("listener exception:{}", (Object)JsonUtils.toJson((Object)eventLog), (Object)e);
            if (!this.async()) {
                throw new WorkflowListenerException(e.getMessage());
            }
            result = ListenerResult.fail(e);
        }
        finally {
            eventLog.setEndTime(new Date());
            this.eventLogStorage.insert(eventLog);
        }
        return result;
    }

    @Override
    public boolean async() {
        return this.eventListener.async();
    }

    protected EventLog buildEventLog(WorkflowContext context) {
        ProcessInstance processInstance = context.getProcessInstance();
        Element currentElement = context.getCurrentElement();
        return new EventLog().setProcessInstId(processInstance.getId()).setProcessName(processInstance.getName()).setProcessDisplayName(processInstance.getDisplayName()).setBusinessId(context.getProcessForm().getBusinessId()).setElementName(currentElement.getName()).setElementDisplayName(currentElement.getDisplayName()).setEventType(this.event().getClass().getSimpleName()).setEvent(this.event().name()).setListener(this.eventListener.name()).setState(EventState.EXECUTING.getState()).setAsync(this.async()).setIp(NetworkUtils.getLocalIp()).setStartTime(new Date());
    }
}

