/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core;

import java.lang.reflect.UndeclaredThrowableException;
import org.apache.inlong.manager.workflow.exception.WorkflowNoRollbackException;
import org.apache.inlong.manager.workflow.exception.WorkflowRollbackOnceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.util.Assert;

public class TransactionHelper {
    private static final Logger log = LoggerFactory.getLogger(TransactionHelper.class);
    private PlatformTransactionManager transactionManager;

    public TransactionHelper(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public <T> T execute(TransactionCallback<T> action, int propagationBehavior) throws TransactionException {
        Object result;
        Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"No PlatformTransactionManager set");
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(propagationBehavior);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            result = action.doInTransaction(status);
        }
        catch (WorkflowRollbackOnceException e) {
            this.rollbackOnException(status, e);
            throw new WorkflowNoRollbackException(e.getMessage());
        }
        catch (WorkflowNoRollbackException e) {
            this.transactionManager.commit(status);
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.rollbackOnException(status, e);
            throw e;
        }
        catch (Throwable e) {
            this.rollbackOnException(status, e);
            throw new UndeclaredThrowableException(e, "TransactionCallback threw undeclared checked exception");
        }
        this.transactionManager.commit(status);
        return (T)result;
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) throws TransactionException {
        Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"No PlatformTransactionManager set");
        log.debug("Initiating transaction rollback on application exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (TransactionSystemException e) {
            log.error("Application exception overridden by rollback exception", ex);
            e.initApplicationException(ex);
            throw e;
        }
        catch (Error | RuntimeException e) {
            log.error("Application exception overridden by rollback exception", ex);
            throw e;
        }
    }
}

