/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.annotation.MapperScans;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScan.class.getName()));
        if (mapperScanAttrs != null) {
            this.registerBeanDefinitions(mapperScanAttrs, registry);
        }
    }

    void registerBeanDefinitions(AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry) {
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        Optional.ofNullable(this.resourceLoader).ifPresent(arg_0 -> ((ClassPathMapperScanner)scanner).setResourceLoader(arg_0));
        Class annotationClass = annoAttrs.getClass("annotationClass");
        if (!Annotation.class.equals((Object)annotationClass)) {
            scanner.setAnnotationClass(annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            scanner.setMarkerInterface(markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            scanner.setBeanNameGenerator((BeanNameGenerator)BeanUtils.instantiateClass((Class)generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            scanner.setMapperFactoryBeanClass(mapperFactoryBeanClass);
        }
        scanner.setSqlSessionTemplateBeanName(annoAttrs.getString("sqlSessionTemplateRef"));
        scanner.setSqlSessionFactoryBeanName(annoAttrs.getString("sqlSessionFactoryRef"));
        ArrayList basePackages = new ArrayList();
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("value")).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("basePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getClassArray("basePackageClasses")).map(ClassUtils::getPackageName).collect(Collectors.toList()));
        scanner.registerFilters();
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    static class RepeatingRegistrar
    extends MapperScannerRegistrar {
        RepeatingRegistrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes mapperScansAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScans.class.getName()));
            if (mapperScansAttrs != null) {
                Arrays.stream(mapperScansAttrs.getAnnotationArray("value")).forEach(mapperScanAttrs -> this.registerBeanDefinitions((AnnotationAttributes)mapperScanAttrs, registry));
            }
        }
    }
}

