/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.util;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.inlong.sort.configuration.Configuration;
import org.apache.inlong.sort.configuration.Constants;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperUtils.class);

    public static CuratorFramework startCuratorFramework(Configuration configuration) {
        ACLProvider aclProvider;
        Preconditions.checkNotNull(configuration, "configuration");
        String zkQuorum = configuration.getValue(Constants.ZOOKEEPER_QUORUM);
        if (zkQuorum == null || StringUtils.isBlank(zkQuorum)) {
            throw new RuntimeException("No valid ZooKeeper quorum has been specified. You can specify the quorum via the configuration key '" + Constants.ZOOKEEPER_QUORUM.key() + "'.");
        }
        int sessionTimeout = configuration.getInteger(Constants.ZOOKEEPER_SESSION_TIMEOUT);
        int connectionTimeout = configuration.getInteger(Constants.ZOOKEEPER_CONNECTION_TIMEOUT);
        int retryWait = configuration.getInteger(Constants.ZOOKEEPER_RETRY_WAIT);
        int maxRetryAttempts = configuration.getInteger(Constants.ZOOKEEPER_MAX_RETRY_ATTEMPTS);
        boolean disableSaslClient = configuration.getBoolean(Constants.ZOOKEEPER_SASL_DISABLE);
        ZkClientACLMode aclMode = ZkClientACLMode.fromConfig(configuration);
        if (disableSaslClient && aclMode == ZkClientACLMode.CREATOR) {
            String errorMessage = "Cannot set ACL role to " + (Object)((Object)aclMode) + "  since SASL authentication is disabled through the " + Constants.ZOOKEEPER_SASL_DISABLE.key() + " property";
            LOG.warn(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        if (aclMode == ZkClientACLMode.CREATOR) {
            LOG.info("Enforcing creator for ZK connections");
            aclProvider = new SecureAclProvider();
        } else {
            LOG.info("Enforcing default ACL for ZK connections");
            aclProvider = new DefaultACLProvider();
        }
        String root = configuration.getValue(Constants.ZOOKEEPER_ROOT);
        LOG.info("Using '{}' as Zookeeper namespace.", (Object)root);
        CuratorFramework cf = CuratorFrameworkFactory.builder().connectString(zkQuorum).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).retryPolicy(new ExponentialBackoffRetry(retryWait, maxRetryAttempts)).namespace(root.startsWith("/") ? root.substring(1) : root).aclProvider(aclProvider).build();
        cf.start();
        return cf;
    }

    public static String getZooKeeperEnsemble(Configuration config) throws IllegalStateException {
        String zkQuorum = config.getValue(Constants.ZOOKEEPER_QUORUM);
        if (zkQuorum == null || StringUtils.isBlank(zkQuorum)) {
            throw new IllegalStateException("No ZooKeeper quorum specified in config.");
        }
        zkQuorum = zkQuorum.replaceAll("\\s+", "");
        return zkQuorum;
    }

    public static String generateZookeeperPath(String root, String namespace) {
        if (!namespace.startsWith("/")) {
            namespace = '/' + namespace;
        }
        if (namespace.endsWith("/")) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        return root + namespace;
    }

    public static CuratorFramework useNamespaceAndEnsurePath(CuratorFramework client, String path) throws Exception {
        Preconditions.checkNotNull(client, "client must not be null");
        Preconditions.checkNotNull(path, "path must not be null");
        client.newNamespaceAwareEnsurePath(path).ensure(client.getZookeeperClient());
        return client.usingNamespace(ZooKeeperUtils.generateZookeeperPath(client.getNamespace(), path));
    }

    public static String createRecursive(CuratorFramework zkClient, String nodePath, byte[] data, CreateMode createMode) throws Exception {
        int lastsp;
        if (!nodePath.startsWith("/")) {
            throw KeeperException.create(KeeperException.Code.NONODE, "path " + nodePath + " is invalid");
        }
        if (nodePath.endsWith("/")) {
            nodePath = nodePath.substring(0, nodePath.length() - 1);
        }
        if ((lastsp = nodePath.lastIndexOf("/")) == 0) {
            return (String)((ACLBackgroundPathAndBytesable)zkClient.create().withMode(createMode)).forPath(nodePath);
        }
        String parent = nodePath.substring(0, lastsp);
        if (zkClient.checkExists().forPath(parent) == null) {
            ZooKeeperUtils.createRecursive(zkClient, parent, null, CreateMode.PERSISTENT);
        }
        return (String)((ACLBackgroundPathAndBytesable)zkClient.create().withMode(createMode)).forPath(nodePath, data);
    }

    private ZooKeeperUtils() {
        throw new RuntimeException();
    }

    public static enum ZkClientACLMode {
        CREATOR,
        OPEN;


        public static ZkClientACLMode fromConfig(Configuration config) {
            String aclMode = config.getString(Constants.ZOOKEEPER_CLIENT_ACL);
            if (aclMode == null || aclMode.equalsIgnoreCase(OPEN.name())) {
                return OPEN;
            }
            if (aclMode.equalsIgnoreCase(CREATOR.name())) {
                return CREATOR;
            }
            String message = "Unsupported ACL option: [" + aclMode + "] provided";
            LOG.error(message);
            throw new IllegalStateException(message);
        }
    }

    public static class SecureAclProvider
    implements ACLProvider {
        @Override
        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        @Override
        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

