/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.sink;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.sink.SinkInfo;

public class HiveSinkInfo
extends SinkInfo {
    private static final long serialVersionUID = -333999329240274826L;
    @JsonProperty(value="hive_server_jdbc_url")
    private final String hiveServerJdbcUrl;
    @JsonProperty(value="database")
    private final String databaseName;
    @JsonProperty(value="table")
    private final String tableName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="username")
    private final String username;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="data_path")
    private final String dataPath;
    @JsonProperty(value="partitions")
    private final HivePartitionInfo[] partitions;
    @JsonProperty(value="file_format")
    private final HiveFileFormat hiveFileFormat;

    public HiveSinkInfo(@JsonProperty(value="fields") FieldInfo[] fields, @JsonProperty(value="hive_server_jdbc_url") String hiveServerJdbcUrl, @JsonProperty(value="database") String databaseName, @JsonProperty(value="table") String tableName, @JsonProperty(value="username") @Nullable String username, @JsonProperty(value="password") @Nullable String password, @JsonProperty(value="data_path") String dataPath, @JsonProperty(value="partitions") HivePartitionInfo[] partitions, @JsonProperty(value="file_format") HiveFileFormat hiveFileFormat) {
        super(fields);
        this.hiveServerJdbcUrl = Preconditions.checkNotNull(hiveServerJdbcUrl);
        this.databaseName = Preconditions.checkNotNull(databaseName);
        this.tableName = Preconditions.checkNotNull(tableName);
        this.username = username;
        this.password = password;
        this.dataPath = Preconditions.checkNotNull(dataPath);
        this.partitions = Preconditions.checkNotNull(partitions);
        this.hiveFileFormat = Preconditions.checkNotNull(hiveFileFormat);
    }

    @JsonProperty(value="hive_server_jdbc_url")
    public String getHiveServerJdbcUrl() {
        return this.hiveServerJdbcUrl;
    }

    @JsonProperty(value="database")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="table")
    public String getTableName() {
        return this.tableName;
    }

    @Nullable
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @Nullable
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="data_path")
    public String getDataPath() {
        return this.dataPath;
    }

    @JsonProperty(value="partitions")
    public HivePartitionInfo[] getPartitions() {
        return this.partitions;
    }

    @JsonProperty(value="file_format")
    public HiveFileFormat getHiveFileFormat() {
        return this.hiveFileFormat;
    }

    public static class ParquetFileFormat
    implements HiveFileFormat {
    }

    public static class SequenceFileFormat
    implements HiveFileFormat {
        @JsonProperty(value="splitter")
        private final Character splitter;
        @JsonProperty(value="buffer_size")
        private final int bufferSize;

        public SequenceFileFormat(@JsonProperty(value="splitter") Character splitter, @JsonProperty(value="buffer_size") int bufferSize) {
            this.splitter = splitter;
            this.bufferSize = bufferSize;
        }

        @JsonProperty(value="splitter")
        public Character getSplitter() {
            return this.splitter;
        }

        @JsonProperty(value="buffer_size")
        public int getBufferSize() {
            return this.bufferSize;
        }
    }

    public static class OrcFileFormat
    implements HiveFileFormat {
        @JsonProperty(value="batch_size")
        private final int batchSize;

        public OrcFileFormat(@JsonProperty(value="batch_size") int batchSize) {
            this.batchSize = batchSize;
        }

        @JsonProperty(value="batch_size")
        public int getBatchSize() {
            return this.batchSize;
        }
    }

    public static class TextFileFormat
    implements HiveFileFormat {
        @JsonProperty(value="splitter")
        private final Character splitter;

        public TextFileFormat(@JsonProperty(value="splitter") Character splitter) {
            this.splitter = splitter;
        }

        @JsonProperty(value="splitter")
        public Character getSplitter() {
            return this.splitter;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextFileFormat.class, name="text"), @JsonSubTypes.Type(value=OrcFileFormat.class, name="orc"), @JsonSubTypes.Type(value=SequenceFileFormat.class, name="sequence"), @JsonSubTypes.Type(value=ParquetFileFormat.class, name="parquet")})
    public static interface HiveFileFormat {
    }

    public static class HiveFieldPartitionInfo
    extends HivePartitionInfo {
        public HiveFieldPartitionInfo(@JsonProperty(value="field_name") String fieldName) {
            super(fieldName);
        }
    }

    public static class HiveTimePartitionInfo
    extends HivePartitionInfo {
        @JsonProperty(value="date_format")
        private final String format;

        public HiveTimePartitionInfo(@JsonProperty(value="field_name") String fieldName, @JsonProperty(value="date_format") String format) {
            super(fieldName);
            this.format = format;
        }

        @JsonProperty(value="date_format")
        public String getFormat() {
            return this.format;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=HiveTimePartitionInfo.class, name="time"), @JsonSubTypes.Type(value=HiveFieldPartitionInfo.class, name="field")})
    public static abstract class HivePartitionInfo {
        @JsonProperty(value="field_name")
        private final String fieldName;

        public HivePartitionInfo(@JsonProperty(value="field_name") String fieldName) {
            this.fieldName = fieldName;
        }

        @JsonProperty(value="field_name")
        public String getFieldName() {
            return this.fieldName;
        }
    }
}

