/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.newconsumption.listener;

import java.util.Collections;
import java.util.Date;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionInfo;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeConsumeGroupRequest;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ConsumptionEntity;
import org.apache.inlong.manager.dao.mapper.ClusterInfoMapper;
import org.apache.inlong.manager.dao.mapper.ConsumptionEntityMapper;
import org.apache.inlong.manager.service.thirdpart.mq.TubeMqOptService;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionApproveForm;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionWorkflowForm;
import org.apache.inlong.manager.workflow.core.QueryService;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;
import org.apache.inlong.manager.workflow.model.view.TaskQuery;
import org.apache.inlong.manager.workflow.util.WorkflowFormParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionCompleteProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionCompleteProcessListener.class);
    @Autowired
    private QueryService queryService;
    @Autowired
    private ConsumptionEntityMapper consumptionEntityMapper;
    @Autowired
    private ClusterInfoMapper clusterInfoMapper;
    @Autowired
    private TubeMqOptService tubeMqOptService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewConsumptionWorkflowForm workflowForm = (NewConsumptionWorkflowForm)context.getProcessForm();
        NewConsumptionApproveForm adminApproveForm = this.getAdminApproveForm(context);
        workflowForm.getConsumptionInfo().setConsumerGroupId(adminApproveForm.getConsumerGroupId());
        this.updateConsumerInfo(workflowForm.getConsumptionInfo().getId(), adminApproveForm.getConsumerGroupId());
        String middlewareType = workflowForm.getConsumptionInfo().getMiddlewareType();
        if ("TUBE".equalsIgnoreCase(middlewareType)) {
            this.createTubeConsumerGroup(workflowForm.getConsumptionInfo());
            return ListenerResult.success((String)"Create Tube Consumer Group");
        }
        throw new BusinessException(BizErrorCodeEnum.INVALID_PARAMETER, "Middleware type [" + middlewareType + "] not support");
    }

    private NewConsumptionApproveForm getAdminApproveForm(WorkflowContext context) {
        TaskInstance adminTask = (TaskInstance)this.queryService.listTask(TaskQuery.builder().processInstId(context.getProcessInstance().getId()).name("ut_admin").build()).stream().findFirst().orElseThrow(() -> new BusinessException(BizErrorCodeEnum.WORKFLOW_EXE_FAILED, "workflow err,not found task ut_admin"));
        Process process = context.getProcess();
        NewConsumptionApproveForm form = (NewConsumptionApproveForm)WorkflowFormParserUtils.parseTaskForm((TaskInstance)adminTask, (Process)process);
        Preconditions.checkNotNull((Object)form, (String)"form can't be null");
        return form;
    }

    private void updateConsumerInfo(Integer consumerId, String consumerGroupId) {
        ConsumptionEntity update = new ConsumptionEntity();
        update.setId(consumerId);
        update.setStatus(Integer.valueOf(ConsumptionStatus.APPROVED.getStatus()));
        update.setConsumerGroupId(consumerGroupId);
        update.setModifyTime(new Date());
        this.consumptionEntityMapper.updateByPrimaryKeySelective(update);
    }

    private void createTubeConsumerGroup(ConsumptionInfo consumptionInfo) {
        AddTubeConsumeGroupRequest addTubeConsumeGroupRequest = new AddTubeConsumeGroupRequest();
        addTubeConsumeGroupRequest.setClusterId(1);
        addTubeConsumeGroupRequest.setCreateUser(consumptionInfo.getCreator());
        AddTubeConsumeGroupRequest.GroupNameJsonSetBean bean = new AddTubeConsumeGroupRequest.GroupNameJsonSetBean();
        bean.setTopicName(consumptionInfo.getTopic());
        bean.setGroupName(consumptionInfo.getConsumerGroupId());
        addTubeConsumeGroupRequest.setGroupNameJsonSet(Collections.singletonList(bean));
        try {
            this.tubeMqOptService.createNewConsumerGroup(addTubeConsumeGroupRequest);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException(BizErrorCodeEnum.CONSUMER_GROUP_CREATE_FAILED);
        }
    }

    public boolean async() {
        return false;
    }
}

