/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.newconsumption.listener;

import com.alibaba.druid.util.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionApproveForm;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionApproveTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionApproveTaskListener.class);
    @Autowired
    private ConsumptionService consumptionService;

    public TaskEvent event() {
        return TaskEvent.APPROVE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewConsumptionWorkflowForm form = (NewConsumptionWorkflowForm)context.getProcessForm();
        NewConsumptionApproveForm approveForm = (NewConsumptionApproveForm)context.getActionContext().getForm();
        if (StringUtils.equals((String)approveForm.getConsumerGroupId(), (String)form.getConsumptionInfo().getConsumerGroupId())) {
            return ListenerResult.success((String)"The consumer group name has not been modified");
        }
        boolean exitDuplicate = this.consumptionService.isConsumerGroupIdExist(approveForm.getConsumerGroupId(), form.getConsumptionInfo().getId());
        if (exitDuplicate) {
            log.error("consumerGroupId already exist! duplicate :{}", (Object)approveForm.getConsumerGroupId());
            throw new BusinessException(BizErrorCodeEnum.CONSUMER_GROUP_NAME_DUPLICATED);
        }
        return ListenerResult.success((String)("Consumer group name from" + form.getConsumptionInfo().getConsumerGroupId() + "change to " + approveForm.getConsumerGroupId()));
    }

    public boolean async() {
        return false;
    }
}

