/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.sort;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamInfo;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.StorageHiveEntity;
import org.apache.inlong.manager.dao.mapper.StorageHiveEntityMapper;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.thirdpart.sort.SortFieldFormatUtils;
import org.apache.inlong.manager.service.workflow.newbusiness.CreateResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.sort.ZkTools;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.TimestampFormatInfo;
import org.apache.inlong.sort.protocol.DataFlowInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.deserialization.DeserializationInfo;
import org.apache.inlong.sort.protocol.deserialization.TDMsgCsvDeserializationInfo;
import org.apache.inlong.sort.protocol.sink.HiveSinkInfo;
import org.apache.inlong.sort.protocol.sink.SinkInfo;
import org.apache.inlong.sort.protocol.source.SourceInfo;
import org.apache.inlong.sort.protocol.source.TubeSourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushHiveConfigToSortEventListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(PushHiveConfigToSortEventListener.class);
    @Autowired
    private StorageService storageService;
    @Autowired
    private StorageHiveEntityMapper storageHiveMapper;
    @Autowired
    private DataStreamService dataStreamService;
    @Autowired
    private ClusterBean clusterBean;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        if (log.isDebugEnabled()) {
            log.debug("begin push hive config to sort, context={}", (Object)context);
        }
        CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)context.getProcessForm();
        BusinessInfo businessInfo = form.getBusinessInfo();
        String bid = businessInfo.getBusinessIdentifier();
        String dsid = form.getDataStreamIdentifier();
        List storageHiveEntities = this.storageHiveMapper.selectByIdentifier(bid, dsid);
        for (StorageHiveEntity hiveEntity : storageHiveEntities) {
            Integer storageId = hiveEntity.getId();
            StorageHiveInfo hiveStorage = (StorageHiveInfo)this.storageService.getById("HIVE", storageId);
            if (log.isDebugEnabled()) {
                log.debug("hive storage info: {}", (Object)hiveStorage);
            }
            DataFlowInfo dataFlowInfo = this.getDataFlowInfo(businessInfo, hiveStorage);
            if (log.isDebugEnabled()) {
                log.debug("try to push hive config to sort: {}", (Object)JsonUtils.toJson((Object)dataFlowInfo));
            }
            try {
                String zkUrl = this.clusterBean.getZkUrl();
                String zkRoot = this.clusterBean.getZkRoot();
                String sortClusterName = this.clusterBean.getAppName();
                ZkTools.updateDataFlowInfo((DataFlowInfo)dataFlowInfo, (String)sortClusterName, (long)storageId.intValue(), (String)zkUrl, (String)zkRoot);
                ZkTools.addDataFlowToCluster((String)sortClusterName, (long)storageId.intValue(), (String)zkUrl, (String)zkRoot);
            }
            catch (Exception e) {
                log.error("add or update data stream information to zk failed, storageId={} ", (Object)storageId, (Object)e);
                throw new WorkflowListenerException("push hive config to sort failed, reason: " + e.getMessage());
            }
        }
        return ListenerResult.success();
    }

    private DataFlowInfo getDataFlowInfo(BusinessInfo businessInfo, StorageHiveInfo hiveStorage) {
        Stream<FieldInfo> hiveFields = hiveStorage.getHiveFieldList().stream().map(field -> {
            FormatInfo formatInfo = SortFieldFormatUtils.convertFieldFormat(field.getFieldType().toLowerCase());
            return new FieldInfo(field.getFieldName(), formatInfo);
        });
        List<FieldInfo> sinkFields = hiveFields.collect(Collectors.toList());
        FieldInfo partitionFieldInfo = new FieldInfo(hiveStorage.getPrimaryPartition(), (FormatInfo)new TimestampFormatInfo("MILLIS"));
        sinkFields.add(partitionFieldInfo);
        String hiveServerUrl = hiveStorage.getJdbcUrl();
        if (hiveServerUrl != null && !hiveServerUrl.startsWith("jdbc:hive2://")) {
            hiveServerUrl = "jdbc:hive2://" + hiveServerUrl;
        }
        StringBuilder dataPathBuilder = new StringBuilder();
        String hdfsUrl = hiveStorage.getHdfsDefaultFs();
        String warehouseDir = hiveStorage.getWarehouseDir();
        if (hdfsUrl.endsWith("/")) {
            dataPathBuilder.append(hdfsUrl, 0, hdfsUrl.length() - 1);
        } else {
            dataPathBuilder.append(hdfsUrl);
        }
        if (warehouseDir.endsWith("/")) {
            dataPathBuilder.append(warehouseDir, 0, warehouseDir.length() - 1);
        } else {
            dataPathBuilder.append(warehouseDir);
        }
        String dataPath = dataPathBuilder.append("/").append(hiveStorage.getDbName()).append(".db/").append(hiveStorage.getTableName()).toString();
        HiveSinkInfo.TextFileFormat fileFormat = new HiveSinkInfo.TextFileFormat(Character.valueOf(','));
        if (hiveStorage.getFieldSplitter() != null) {
            char c = (char)Integer.parseInt(hiveStorage.getFieldSplitter());
            fileFormat = new HiveSinkInfo.TextFileFormat(Character.valueOf(c));
        }
        HiveSinkInfo hiveSinkInfo = new HiveSinkInfo(sinkFields.toArray(new FieldInfo[0]), hiveServerUrl, hiveStorage.getDbName(), hiveStorage.getTableName(), hiveStorage.getUsername(), hiveStorage.getPassword(), dataPath, (HiveSinkInfo.HivePartitionInfo[])Stream.of(new HiveSinkInfo.HiveTimePartitionInfo(hiveStorage.getPrimaryPartition(), "yyyyMMddHH")).toArray(HiveSinkInfo.HivePartitionInfo[]::new), (HiveSinkInfo.HiveFileFormat)fileFormat);
        DataStreamInfo dataStream = this.dataStreamService.get(hiveStorage.getBusinessIdentifier(), hiveStorage.getDataStreamIdentifier());
        Stream<FieldInfo> streamFields = dataStream.getFieldList().stream().map(field -> {
            FormatInfo formatInfo = SortFieldFormatUtils.convertFieldFormat(field.getFieldType().toLowerCase());
            return new FieldInfo(field.getFieldName(), formatInfo);
        });
        String topic = businessInfo.getMqResourceObj();
        String consumeGroupName = "sort_" + businessInfo.getMqResourceObj() + "_consumer_group";
        TDMsgCsvDeserializationInfo deserializationInfo = null;
        if ("TEXT".equalsIgnoreCase(dataStream.getDataType())) {
            char c = (char)Integer.parseInt(dataStream.getFileDelimiter());
            deserializationInfo = new TDMsgCsvDeserializationInfo(hiveStorage.getDataStreamIdentifier(), c);
        }
        TubeSourceInfo sourceInfo = new TubeSourceInfo(topic, this.clusterBean.getTubeMaster(), consumeGroupName, (DeserializationInfo)deserializationInfo, (FieldInfo[])streamFields.toArray(FieldInfo[]::new));
        return new DataFlowInfo((long)hiveStorage.getId().intValue(), (SourceInfo)sourceInfo, (SinkInfo)hiveSinkInfo);
    }

    public boolean async() {
        return false;
    }
}

