/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.Collections;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeMqTopicRequest;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.thirdpart.mq.TubeMqOptService;
import org.apache.inlong.manager.service.workflow.newbusiness.CreateResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeTopicTaskEventListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeTopicTaskEventListener.class);
    @Autowired
    private TubeMqOptService tubeMqOptService;
    @Autowired
    private BusinessService businessService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)context.getProcessForm();
        log.info("begin create tube topic for bid={}", (Object)form.getBusinessId());
        String bid = form.getBusinessId();
        try {
            BusinessInfo businessInfo = this.businessService.get(bid);
            String topicName = businessInfo.getMqResourceObj();
            AddTubeMqTopicRequest request = new AddTubeMqTopicRequest();
            request.setUser("inlong-manager");
            AddTubeMqTopicRequest.AddTopicTasksBean tasksBean = new AddTubeMqTopicRequest.AddTopicTasksBean();
            tasksBean.setTopicName(topicName);
            request.setAddTopicTasks(Collections.singletonList(tasksBean));
            this.tubeMqOptService.createNewTopic(request);
            log.info("finish to create tube topic for bid={}", (Object)bid);
        }
        catch (Exception e) {
            log.error("create tube topic for bid={} error, exception {} ", new Object[]{bid, e.getMessage(), e});
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

