/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.hive.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.query.hive.HiveColumnQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveTableQueryBean;
import org.apache.inlong.manager.service.thirdpart.hive.builder.SqlBuilder;

public class HiveAddColumnSqlBuilder
extends SqlBuilder<HiveTableQueryBean> {
    @Override
    public String buildDDL(HiveTableQueryBean table) {
        String dbTableName = "`" + table.getDbName() + "." + table.getTableName() + "`";
        this.ddl.append("ALTER TABLE ").append(dbTableName);
        this.ddl.append(this.buildColumns(table.getColumns()));
        return this.ddl.toString();
    }

    private String buildColumns(List<HiveColumnQueryBean> columns) {
        ArrayList<String> columnInfoList = new ArrayList<String>();
        for (HiveColumnQueryBean columnBean : columns) {
            if (columnBean.isPartition()) continue;
            String columnName = "`" + columnBean.getColumnName() + "`";
            StringBuilder columnInfo = new StringBuilder().append(columnName).append(" ").append(columnBean.getColumnType());
            if (StringUtils.isNotEmpty((CharSequence)columnBean.getColumnDesc())) {
                columnInfo.append(" COMMENT ").append("'").append(columnBean.getColumnDesc()).append("'");
            }
            columnInfoList.add(columnInfo.toString());
        }
        return " ADD COLUMNS (" + StringUtils.join(columnInfoList, (String)",") + ") ";
    }

    @Override
    public String getOPT() {
        return null;
    }
}

