/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamInfoToHiveConfig;
import org.apache.inlong.manager.common.pojo.query.ColumnInfoBean;
import org.apache.inlong.manager.common.pojo.query.DatabaseQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveColumnQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveTableQueryBean;
import org.apache.inlong.manager.dao.entity.StorageHiveFieldEntity;
import org.apache.inlong.manager.dao.mapper.StorageHiveFieldEntityMapper;
import org.apache.inlong.manager.service.core.DataSourceService;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.workflow.exception.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HiveTableOperator {
    private static final Logger log = LoggerFactory.getLogger(HiveTableOperator.class);
    @Autowired
    private StorageService storageService;
    @Autowired
    private DataSourceService<DatabaseQueryBean, HiveTableQueryBean> dataSourceService;
    @Autowired
    private StorageHiveFieldEntityMapper storageHiveFieldMapper;

    public void createHiveTable(String bid, DataStreamInfoToHiveConfig hiveConfig) {
        if (log.isDebugEnabled()) {
            log.debug("begin create hive table for business={}, hiveConfig={}", (Object)bid, (Object)hiveConfig);
        }
        HiveTableQueryBean tableBean = this.getTableQueryBean(hiveConfig);
        try {
            this.dataSourceService.createDb(tableBean);
            List<ColumnInfoBean> columns = this.dataSourceService.queryColumns(tableBean);
            if (columns.size() == 0) {
                this.dataSourceService.createTable(tableBean);
            } else {
                List columnsSkipHistory = tableBean.getColumns().stream().skip(columns.size()).collect(Collectors.toList());
                if (columnsSkipHistory.size() != 0) {
                    tableBean.setColumns(columnsSkipHistory);
                    this.dataSourceService.createColumn(tableBean);
                }
            }
            this.storageService.updateHiveStatusById(hiveConfig.getId(), EntityStatus.DATA_STORAGE_CONFIG_SUCCESSFUL.getCode(), "create hive table success");
        }
        catch (Throwable e) {
            log.error("create hive table error, ", e);
            this.storageService.updateHiveStatusById(hiveConfig.getId(), EntityStatus.DATA_STORAGE_CONFIG_FAILED.getCode(), e.getMessage());
            throw new WorkflowException("create hive table failed, reason: " + e.getMessage());
        }
        log.info("finish create hive table for business {} ", (Object)bid);
    }

    protected HiveTableQueryBean getTableQueryBean(DataStreamInfoToHiveConfig hiveConfig) {
        String bid = hiveConfig.getBusinessIdentifier();
        String dsid = hiveConfig.getDataStreamIdentifier();
        log.info("begin to get table query bean for bid={}, dsid={}", (Object)bid, (Object)dsid);
        List fieldEntities = this.storageHiveFieldMapper.queryHiveFieldsByStreamId(bid, dsid);
        ArrayList<HiveColumnQueryBean> columnQueryBeans = new ArrayList<HiveColumnQueryBean>();
        for (StorageHiveFieldEntity field : fieldEntities) {
            HiveColumnQueryBean columnBean = new HiveColumnQueryBean();
            columnBean.setColumnName(field.getFieldName());
            columnBean.setColumnType(field.getFieldType());
            columnBean.setColumnDesc(field.getFieldComment());
            columnQueryBeans.add(columnBean);
        }
        String partitionField = hiveConfig.getPrimaryPartition();
        if (partitionField != null) {
            HiveColumnQueryBean partColumn = new HiveColumnQueryBean();
            partColumn.setPartition(true);
            partColumn.setColumnName(partitionField);
            partColumn.setColumnType("string");
            columnQueryBeans.add(partColumn);
        }
        HiveTableQueryBean queryBean = new HiveTableQueryBean();
        queryBean.setColumns(columnQueryBeans);
        if (hiveConfig.getFieldSplitter() != null) {
            char ch = (char)Integer.parseInt(hiveConfig.getFieldSplitter());
            queryBean.setFieldTerSymbol(String.valueOf(ch));
        }
        queryBean.setUsername(hiveConfig.getUserName());
        queryBean.setPassword(hiveConfig.getPassword());
        queryBean.setTableName(hiveConfig.getTableName());
        queryBean.setDbName(hiveConfig.getDbName());
        queryBean.setJdbcUrl(hiveConfig.getJdbcUrl());
        if (log.isDebugEnabled()) {
            log.debug("success to get table query bean={}", (Object)queryBean);
        }
        return queryBean;
    }
}

