/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.operationlog;

import java.util.Date;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.common.util.NetworkUtils;
import org.apache.inlong.manager.dao.entity.OperationLogEntity;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.service.core.operationlog.OperationLogPool;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OperationLogRecorder {
    private static final Logger log = LoggerFactory.getLogger(OperationLogRecorder.class);
    private static final String ANONYMOUS_USER = "AnonymousUser";

    public static Object doAround(ProceedingJoinPoint joinPoint, OperationLog operationLog) throws Throwable {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return joinPoint.proceed();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        UserDetail userDetail = Optional.ofNullable(LoginUserUtil.getLoginUserDetail()).orElseGet(UserDetail::new);
        String operator = userDetail.getUserName();
        operator = StringUtils.isBlank((CharSequence)operator) ? ANONYMOUS_USER : operator;
        String requestUrl = request.getRequestURI();
        String httpMethod = request.getMethod();
        String remoteAddress = NetworkUtils.getClientIpAddress((HttpServletRequest)request);
        String param = JsonUtils.toJson((Object)request.getParameterMap());
        String body = JsonUtils.toJson((Object)joinPoint.getArgs());
        OperationType operationType = operationLog.operation();
        long start = System.currentTimeMillis();
        boolean success = true;
        String errMsg = "";
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Throwable throwable) {
            success = false;
            errMsg = throwable.getMessage();
            throw throwable;
        }
        finally {
            long costTime = System.currentTimeMillis() - start;
            OperationLogEntity operationLogEntity = new OperationLogEntity();
            operationLogEntity.setOperationType(operationType.name());
            operationLogEntity.setHttpMethod(httpMethod);
            operationLogEntity.setOperator(operator);
            operationLogEntity.setRequestUrl(requestUrl);
            operationLogEntity.setRemoteAddress(remoteAddress);
            operationLogEntity.setCostTime(Long.valueOf(costTime));
            operationLogEntity.setBody(body);
            operationLogEntity.setParam(param);
            operationLogEntity.setStatus(Boolean.valueOf(success));
            operationLogEntity.setRequestTime(new Date());
            operationLogEntity.setErrMsg(errMsg);
            if (operationLog.db()) {
                OperationLogPool.publish(operationLogEntity);
            } else if (success) {
                log.info("operation log: {}", (Object)JsonUtils.toJson((Object)operationLogEntity));
            } else {
                log.error("request handle failed : {}", (Object)JsonUtils.toJson((Object)operationLogEntity));
            }
        }
    }
}

