/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.apache.inlong.manager.common.beans.PageResult;
import org.apache.inlong.manager.common.util.PageUtils;
import org.apache.inlong.manager.service.core.WorkflowEventService;
import org.apache.inlong.manager.workflow.core.EventListenerService;
import org.apache.inlong.manager.workflow.core.QueryService;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.model.instance.EventLog;
import org.apache.inlong.manager.workflow.model.view.EventLogQuery;
import org.apache.inlong.manager.workflow.model.view.EventLogView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowEventServiceImpl
implements WorkflowEventService {
    @Autowired
    private QueryService queryService;
    @Autowired
    private EventListenerService eventListenerService;

    @Override
    public EventLogView get(Integer id) {
        return EventLogView.fromEventLog((EventLog)this.queryService.getEventLog(id), (boolean)true);
    }

    @Override
    public PageResult<EventLogView> list(EventLogQuery query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page page = (Page)this.queryService.listEventLog(query);
        return PageUtils.getPageResult((Page)page, log -> EventLogView.fromEventLog((EventLog)log, (boolean)false));
    }

    @Override
    public void executeEventListener(Integer eventLogId) {
        this.eventListenerService.executeEventListener(eventLogId);
    }

    @Override
    public void executeProcessEventListener(Integer processInstId, String listenerName) {
        this.eventListenerService.executeProcessEventListener(processInstId, listenerName);
    }

    @Override
    public void executeTaskEventListener(Integer taskInstId, String listenerName) {
        this.eventListenerService.executeTaskEventListener(taskInstId, listenerName);
    }

    @Override
    public void triggerProcessEvent(Integer processInstId, ProcessEvent processEvent) {
        this.eventListenerService.triggerProcessEvent(processInstId, processEvent);
    }

    @Override
    public void triggerTaskEvent(Integer taskInstId, TaskEvent taskEvent) {
        this.eventListenerService.triggerTaskEvent(taskInstId, taskEvent);
    }
}

