/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageInfo;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageListVO;
import org.apache.inlong.manager.common.pojo.datastorage.StorageApproveInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveListVO;
import org.apache.inlong.manager.common.pojo.datastorage.StoragePageRequest;
import org.apache.inlong.manager.common.pojo.datastorage.StorageSummaryInfo;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.StorageHiveEntity;
import org.apache.inlong.manager.dao.mapper.StorageHiveEntityMapper;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.core.impl.StorageBaseOperation;
import org.apache.inlong.manager.service.core.impl.StorageHiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageServiceImpl
extends StorageBaseOperation
implements StorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageServiceImpl.class);
    @Autowired
    private StorageHiveOperation hiveOperation;
    @Autowired
    private StorageHiveEntityMapper hiveStorageMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(BaseStorageInfo storageInfo, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to save storage info={}", (Object)storageInfo);
        }
        Preconditions.checkNotNull((Object)storageInfo, (String)"storage info is empty");
        String bid = storageInfo.getBusinessIdentifier();
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        String dsid = storageInfo.getDataStreamIdentifier();
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        BusinessEntity businessEntity = super.checkBizIsTempStatus(bid);
        String storageType = storageInfo.getStorageType();
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        int id = this.hiveOperation.saveHiveStorage(storageInfo, operator);
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(businessEntity.getStatus())) {
            this.executorService.execute(new StorageBaseOperation.WorkflowStartRunnable(operator, businessEntity, dsid));
        }
        LOGGER.info("success to save storage info");
        return id;
    }

    @Override
    public BaseStorageInfo getById(String storageType, Integer id) {
        LOGGER.debug("begin to get storage by storageType={}, id={}", (Object)storageType, (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"storage id is null");
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        BaseStorageInfo storageInfo = this.hiveOperation.getHiveStorage(id);
        LOGGER.info("success to get storage info");
        return storageInfo;
    }

    @Override
    public int getCountByIdentifier(String bid, String dsid) {
        LOGGER.debug("begin to get storage count by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        int count = this.hiveStorageMapper.selectCountByIdentifier(bid, dsid);
        LOGGER.info("the storage count={} by bid={}, dsid={}", new Object[]{count, bid, dsid});
        return count;
    }

    @Override
    public List<BaseStorageInfo> listByIdentifier(String bid, String dsid) {
        LOGGER.debug("begin to list storage by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        ArrayList<BaseStorageInfo> storageInfoList = new ArrayList<BaseStorageInfo>();
        this.hiveOperation.setHiveStorageInfo(bid, dsid, storageInfoList);
        LOGGER.info("success to list storage info");
        return storageInfoList;
    }

    @Override
    public List<StorageSummaryInfo> listSummaryByIdentifier(String bid, String dsid) {
        LOGGER.debug("begin to list storage summary by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        ArrayList<StorageSummaryInfo> totalList = new ArrayList<StorageSummaryInfo>();
        List hiveSummaryList = this.hiveStorageMapper.selectSummaryByIdentifier(bid, dsid);
        totalList.addAll(hiveSummaryList);
        LOGGER.info("success to list storage summary");
        return totalList;
    }

    @Override
    public PageInfo<? extends BaseStorageListVO> listByCondition(StoragePageRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to list storage page by {}", (Object)request);
        }
        Preconditions.checkNotNull((Object)request.getBid(), (String)"businessIdentifier is empty");
        String storageType = request.getStorageType();
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        PageInfo<StorageHiveListVO> page = this.hiveOperation.getHiveStorageList(request);
        LOGGER.info("success to list storage page");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean update(BaseStorageInfo storageInfo, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update storage info={}", (Object)storageInfo);
        }
        Preconditions.checkNotNull((Object)storageInfo, (String)"storage info is empty");
        String bid = storageInfo.getBusinessIdentifier();
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        String dsid = storageInfo.getDataStreamIdentifier();
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        BusinessEntity businessEntity = super.checkBizIsTempStatus(bid);
        String storageType = storageInfo.getStorageType();
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        this.hiveOperation.updateHiveStorage(businessEntity.getStatus(), storageInfo, operator);
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(businessEntity.getStatus())) {
            this.executorService.execute(new StorageBaseOperation.WorkflowStartRunnable(operator, businessEntity, dsid));
        }
        LOGGER.info("success to update storage info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean delete(String storageType, Integer id, String operator) {
        LOGGER.debug("begin to delete storage by storageType={}, id={}", (Object)storageType, (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"storage id is null");
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        boolean result = this.hiveOperation.logicDeleteHiveStorage(id, operator);
        LOGGER.info("success to delete storage info");
        return result;
    }

    @Override
    public void updateHiveStatusById(int id, int status, String log) {
        StorageHiveEntity entity = new StorageHiveEntity();
        entity.setId(Integer.valueOf(id));
        entity.setStatus(Integer.valueOf(status));
        entity.setOptLog(log);
        this.hiveStorageMapper.updateStorageStatusById(entity);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean deleteAllByIdentifier(String bid, String dsid) {
        LOGGER.debug("begin to delete all storage info by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        this.checkBizIsTempStatus(bid);
        this.hiveOperation.deleteHiveByIdentifier(bid, dsid);
        LOGGER.info("success to delete all storage info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteAllByIdentifier(String bid, String dsid, String operator) {
        LOGGER.debug("begin to logic delete all storage info by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        this.checkBizIsTempStatus(bid);
        this.hiveOperation.logicDeleteHiveByIdentifier(bid, dsid, operator);
        LOGGER.info("success to logic delete all storage info");
        return true;
    }

    @Override
    public List<String> filterStreamIdByStorageType(String bid, String storageType, List<String> dsidList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to filter stream by bid={}, storageType={}, dsidList={}", new Object[]{bid, storageType, dsidList});
        }
        List<String> resultList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)storageType) || CollectionUtils.isEmpty(dsidList)) {
            return resultList;
        }
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        resultList = this.hiveStorageMapper.selectDataStreamExists(bid, dsidList);
        LOGGER.info("success to filter stream");
        return resultList;
    }

    @Override
    public List<String> getStorageTypeList(String bid, String dsid) {
        LOGGER.debug("begin to get storage type list by bid={}, dsid={}", (Object)bid, (Object)dsid);
        ArrayList<String> resultList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)dsid)) {
            return resultList;
        }
        if (this.hiveStorageMapper.selectCountByIdentifier(bid, dsid) > 0) {
            resultList.add("HIVE");
        }
        LOGGER.info("success to get storage type list");
        return resultList;
    }

    @Override
    public boolean updateAfterApprove(List<StorageApproveInfo> storageApproveList, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update storage after approve={}", storageApproveList);
        }
        if (CollectionUtils.isEmpty(storageApproveList)) {
            return true;
        }
        for (StorageApproveInfo info : storageApproveList) {
            String storageType = info.getStorageType();
            Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
            if ("HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
                StorageHiveEntity hiveEntity = new StorageHiveEntity();
                hiveEntity.setId(info.getId());
                hiveEntity.setModifier(operator);
                hiveEntity.setStatus(EntityStatus.DATA_STORAGE_CONFIG_ING.getCode());
                this.hiveStorageMapper.updateByPrimaryKeySelective(hiveEntity);
                continue;
            }
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        LOGGER.info("success to update storage after approve");
        return true;
    }
}

