/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.beans.PageResult;
import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.pojo.business.BusinessTopicVO;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionInfo;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionListVo;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionQuery;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionSummary;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionUpdateInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.PageUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ConsumptionEntity;
import org.apache.inlong.manager.dao.mapper.ConsumptionEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowResult;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionWorkflowForm;
import org.apache.inlong.manager.workflow.model.view.CountByKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ConsumptionServiceImpl
implements ConsumptionService {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionServiceImpl.class);
    @Autowired
    private ConsumptionEntityMapper consumptionMapper;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private BusinessService businessService;
    @Autowired
    private ClusterBean clusterBean;

    @Override
    public ConsumptionSummary getSummary(ConsumptionQuery query) {
        Map<String, Integer> countByState = this.consumptionMapper.countByStatus(query).stream().collect(Collectors.toMap(CountByKey::getKey, CountByKey::getValue));
        return ConsumptionSummary.builder().totalCount(Integer.valueOf(countByState.values().stream().mapToInt(c -> c).sum())).waitingAssignCount(countByState.getOrDefault(ConsumptionStatus.WAITING_ASSIGN.getStatus() + "", 0)).waitingApproveCount(countByState.getOrDefault(ConsumptionStatus.WAITING_APPROVE.getStatus() + "", 0)).rejectedCount(countByState.getOrDefault(ConsumptionStatus.REJECTED.getStatus() + "", 0)).build();
    }

    @Override
    public PageResult<ConsumptionListVo> list(ConsumptionQuery query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page pageResult = (Page)this.consumptionMapper.listByQuery(query);
        PageInfo pageInfo = pageResult.toPageInfo(entity -> (ConsumptionListVo)CommonBeanUtils.copyProperties((Object)entity, ConsumptionListVo::new));
        pageInfo.setTotal(pageResult.getTotal());
        return PageUtils.getPageResult((PageInfo)pageInfo);
    }

    @Override
    public ConsumptionInfo getInfo(Integer id) {
        Preconditions.checkNotNull((Object)id, (String)"Consumption id can't be null");
        ConsumptionEntity entity = this.consumptionMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, () -> "Consumption not exist with id:" + id);
        ConsumptionInfo consumptionInfo = (ConsumptionInfo)CommonBeanUtils.copyProperties((Object)entity, ConsumptionInfo::new);
        consumptionInfo.setMasterUrl(this.clusterBean.getTubeMaster());
        return consumptionInfo;
    }

    @Override
    public ConsumptionInfo getInfo(String consumerGroupId) {
        Preconditions.checkNotEmpty((String)consumerGroupId, (String)"ConsumerGroupId can't be null");
        ConsumptionQuery consumptionQuery = new ConsumptionQuery();
        consumptionQuery.setConsumerGroupId(consumerGroupId);
        List result = this.consumptionMapper.listByQuery(consumptionQuery);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        ConsumptionEntity entity = (ConsumptionEntity)result.get(0);
        ConsumptionInfo info = (ConsumptionInfo)CommonBeanUtils.copyProperties((Object)entity, ConsumptionInfo::new);
        info.setMasterUrl(this.clusterBean.getTubeMaster());
        return info;
    }

    @Override
    public boolean isConsumerGroupIdExist(String groupId, Integer excludeSelfId) {
        ConsumptionQuery consumptionQuery = new ConsumptionQuery();
        consumptionQuery.setConsumerGroupId(groupId);
        List result = this.consumptionMapper.listByQuery(consumptionQuery);
        if (excludeSelfId != null) {
            result = result.stream().filter(entity -> !excludeSelfId.equals(entity.getId())).collect(Collectors.toList());
        }
        return !CollectionUtils.isEmpty((Collection)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer save(ConsumptionInfo consumptionInfo, String operator) {
        this.checkConsumptionInfo(consumptionInfo);
        ConsumptionEntity consumptionEntity = this.saveConsumption(consumptionInfo, operator);
        log.debug("success to save consumption {}", (Object)consumptionInfo);
        return consumptionEntity.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer update(ConsumptionUpdateInfo info, String operator) {
        Preconditions.checkNotNull((Object)info, (String)"update info can't be null");
        Preconditions.checkNotNull((Object)info.getId(), (String)"consumption id can't be null");
        ConsumptionInfo consumptionInfo = this.getInfo(info.getId());
        Preconditions.checkNotNull((Object)consumptionInfo, (String)("consumption not exist with id " + info.getId()));
        Preconditions.checkTrue((boolean)consumptionInfo.getInCharges().contains(operator), (String)"operator is not the owner for this consumption");
        ConsumptionEntity entity = new ConsumptionEntity();
        entity.setId(info.getId());
        entity.setInCharges(info.getInCharges());
        entity.setModifier(operator);
        entity.setModifyTime(new Date());
        this.consumptionMapper.updateByPrimaryKeySelective(entity);
        log.debug("success to update consumption {}", (Object)entity);
        return entity.getId();
    }

    @Override
    public void delete(Integer id, String operator) {
        ConsumptionEntity consumptionEntity = this.consumptionMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)consumptionEntity, () -> "consumption not exist with id:" + id);
        int success = this.consumptionMapper.deleteByPrimaryKey(id);
        Preconditions.checkTrue((success > 0 ? 1 : 0) != 0, (String)"delete failed");
    }

    @Override
    public WorkflowResult startProcess(Integer id, String operation) {
        ConsumptionInfo consumptionInfo = this.getInfo(id);
        Preconditions.checkTrue((boolean)ConsumptionStatus.ALLOW_START_WORKFLOW_STATUS.contains(ConsumptionStatus.fromStatus((int)consumptionInfo.getStatus())), (String)"current status not allow start workflow");
        ConsumptionEntity updateConsumptionEntity = new ConsumptionEntity();
        updateConsumptionEntity.setId(consumptionInfo.getId());
        updateConsumptionEntity.setModifyTime(new Date());
        updateConsumptionEntity.setStatus(Integer.valueOf(ConsumptionStatus.WAITING_APPROVE.getStatus()));
        int success = this.consumptionMapper.updateByPrimaryKeySelective(updateConsumptionEntity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"update consumption failed");
        return this.workflowService.start(ProcessName.NEW_CONSUMPTION_WORKFLOW, operation, this.genNewConsumptionWorkflowForm(consumptionInfo));
    }

    private NewConsumptionWorkflowForm genNewConsumptionWorkflowForm(ConsumptionInfo consumptionInfo) {
        NewConsumptionWorkflowForm form = new NewConsumptionWorkflowForm();
        form.setConsumptionInfo(consumptionInfo);
        return form;
    }

    private ConsumptionEntity saveConsumption(ConsumptionInfo consumptionInfo, String operator) {
        Date now = new Date();
        consumptionInfo.setCreateTime(now);
        consumptionInfo.setModifyTime(now);
        consumptionInfo.setModifier(operator);
        consumptionInfo.setCreator(operator);
        ConsumptionEntity entity = (ConsumptionEntity)CommonBeanUtils.copyProperties((Object)consumptionInfo, ConsumptionEntity::new);
        entity.setStatus(Integer.valueOf(ConsumptionStatus.WAITING_ASSIGN.getStatus()));
        entity.setIsDeleted(EntityStatus.UN_DELETED.getCode());
        int success = consumptionInfo.getId() != null ? this.consumptionMapper.updateByPrimaryKey(entity) : this.consumptionMapper.insert(entity);
        Preconditions.checkTrue((success > 0 ? 1 : 0) != 0, (String)"save failed");
        Preconditions.checkNotNull((Object)entity.getId(), (String)"save failed");
        return entity;
    }

    private void checkConsumptionInfo(ConsumptionInfo info) {
        Preconditions.checkNotNull((Object)info, (String)"Consumption info can't be null");
        Preconditions.checkNotNull((Object)info.getConsumerGroupName(), (String)"Consumer Group Name can't be null");
        String groupId = info.getConsumerGroupName().toLowerCase(Locale.ROOT);
        info.setConsumerGroupId(groupId);
        Preconditions.checkTrue((!this.isConsumerGroupIdExist(groupId, info.getId()) ? 1 : 0) != 0, (String)("Consumer Group ID " + groupId + " already exist"));
        if (info.getId() != null) {
            ConsumptionEntity entity = this.consumptionMapper.selectByPrimaryKey(info.getId());
            Preconditions.checkNotNull((Object)entity, (String)("Consumption not exist with id:" + info.getId()));
            ConsumptionStatus consumptionStatus = ConsumptionStatus.fromStatus((int)entity.getStatus());
            Preconditions.checkTrue((boolean)ConsumptionStatus.ALLOW_SAVE_UPDATE_STATUS.contains(consumptionStatus), (String)("Consumption not allowed to update when its status is" + consumptionStatus.name()));
        }
        BusinessTopicVO topicVO = this.businessService.getTopic(info.getBusinessIdentifier());
        Preconditions.checkNotNull((Object)topicVO, (String)("Business not exist :" + info.getBusinessIdentifier()));
        Preconditions.checkTrue((topicVO.getTopicName() != null && topicVO.getTopicName().equals(info.getTopic()) ? 1 : 0) != 0, (String)("Topic [" + info.getTopic() + "] not belong to business " + info.getBusinessIdentifier()));
    }
}

