/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.pojo.commonserver.CommonFileServerInfo;
import org.apache.inlong.manager.common.pojo.commonserver.CommonFileServerListVo;
import org.apache.inlong.manager.common.pojo.commonserver.CommonFileServerPageRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.CommonFileServerEntity;
import org.apache.inlong.manager.dao.mapper.CommonFileServerEntityMapper;
import org.apache.inlong.manager.service.core.CommonFileServerService;
import org.apache.inlong.manager.service.core.builder.CommonFileServerInfoBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonFileServerServiceImpl
implements CommonFileServerService {
    private static final Logger log = LoggerFactory.getLogger(CommonFileServerServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonFileServerServiceImpl.class);
    @Autowired
    private CommonFileServerEntityMapper commonFileServerMapper;

    public static boolean checkStrLen(String text, int maxLength) {
        return text != null && text.length() > maxLength;
    }

    public static boolean ipCheck(String text) {
        if (text != null && !text.isEmpty()) {
            String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
            return text.matches(regex);
        }
        return false;
    }

    @Override
    public int create(CommonFileServerInfo info) throws Exception {
        CommonFileServerEntity record;
        LOGGER.debug("create CommonFileServer info={} ", (Object)info);
        this.checkValidity(info);
        List entities = this.commonFileServerMapper.selectByUsernameAndIpPort(info.getUsername(), info.getIp(), info.getPort());
        if (entities != null && entities.size() > 0) {
            for (CommonFileServerEntity entry : entities) {
                if (entry.getIsDeleted() != 0) continue;
                throw new IllegalArgumentException("Already have a CommonFileServer [" + entry.getId() + "] have the same username/ip/port = [" + entry.getUsername() + "/" + entry.getIp() + "/" + entry.getPort() + "]");
            }
        }
        if ((record = (CommonFileServerEntity)CommonBeanUtils.copyProperties((Object)info, CommonFileServerEntity::new)).getAccessType() == null || record.getAccessType().isEmpty()) {
            record.setAccessType("Agent");
        }
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        record.setStatus(Integer.valueOf(0));
        record.setCreator(userName);
        record.setModifier(userName);
        Date now = new Date();
        record.setCreateTime(now);
        record.setModifyTime(now);
        record.setIsDeleted(EntityStatus.UN_DELETED.getCode());
        int success = this.commonFileServerMapper.insert(record);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"insert into db failed");
        LOGGER.debug("success create CommonFileServer info=[{}] into db entry id={}", (Object)info, (Object)record.getId());
        return record.getId();
    }

    private void checkValidity(CommonFileServerInfo commonFileServerInfo) throws Exception {
        if (commonFileServerInfo.getId() > 0) {
            throw new IllegalArgumentException("CommonFileServer id = [" + commonFileServerInfo.getId() + "] has already exists, please check");
        }
        if (!CommonFileServerServiceImpl.ipCheck(commonFileServerInfo.getIp())) {
            throw new IllegalArgumentException("CommonFileServer ip = [" + commonFileServerInfo.getIp() + "] is not valid ip, please check");
        }
        this.checkStrFieldLength(commonFileServerInfo);
    }

    private void checkStrFieldLength(CommonFileServerInfo commonFileServerInfo) {
        if (CommonFileServerServiceImpl.checkStrLen(commonFileServerInfo.getAccessType(), 128)) {
            throw new IllegalArgumentException("CommonFileServer type = [" + commonFileServerInfo.getAccessType() + "] length is " + commonFileServerInfo.getAccessType().length() + " and too large, The maximum size for the field length is 128.");
        }
        if (CommonFileServerServiceImpl.checkStrLen(commonFileServerInfo.getIssueType(), 128)) {
            throw new IllegalArgumentException("CommonFileServer issueType = [" + commonFileServerInfo.getIssueType() + "] length is " + commonFileServerInfo.getIssueType().length() + " and too large, The maximum size for the field length is 128.");
        }
        if (CommonFileServerServiceImpl.checkStrLen(commonFileServerInfo.getUsername(), 64)) {
            throw new IllegalArgumentException("CommonFileServer username = [" + commonFileServerInfo.getUsername() + "] length is " + commonFileServerInfo.getUsername().length() + " and too large, The maximum size for the field length is 64.");
        }
        if (CommonFileServerServiceImpl.checkStrLen(commonFileServerInfo.getPassword(), 64)) {
            throw new IllegalArgumentException("CommonFileServer password = [" + commonFileServerInfo.getPassword() + "] length is " + commonFileServerInfo.getPassword().length() + " and too large, The maximum size for the field length is 64.");
        }
        if (CommonFileServerServiceImpl.checkStrLen(commonFileServerInfo.getVisiblePerson(), 1024)) {
            throw new IllegalArgumentException("CommonFileServer visiblePerson = [" + commonFileServerInfo.getVisiblePerson() + "] length is " + commonFileServerInfo.getVisiblePerson().length() + " and too large, The maximum size for the field length is 1024.");
        }
        if (CommonFileServerServiceImpl.checkStrLen(commonFileServerInfo.getVisibleGroup(), 1024)) {
            throw new IllegalArgumentException("CommonFileServer visibleGroup = [" + commonFileServerInfo.getVisibleGroup() + "] length is " + commonFileServerInfo.getVisibleGroup().length() + " and too large, The maximum size for the field length is 1024.");
        }
    }

    @Override
    public CommonFileServerInfo get(int id) throws Exception {
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(id));
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        if (this.checkVisible(userName, entity)) {
            return CommonFileServerInfoBuilder.buildFileInfoFromEntity(entity);
        }
        throw new IllegalArgumentException(userName + " has no right to get id=" + id + ", please contact " + entity.getCreator());
    }

    @Override
    public void delete(int id) throws Exception {
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={} delete CommonFileServer id={} ", (Object)userName, (Object)id);
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(id));
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(userName, entity)) {
            throw new IllegalArgumentException(userName + " is not creator, has no right to delete id=" + id + ", please contact " + entity.getCreator());
        }
        Date now = new Date();
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(userName);
        entity.setModifyTime(now);
        int success = this.commonFileServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase delete id = " + id + " failed "));
        LOGGER.info("user={} success delete CommonFileServer id={}", (Object)userName, (Object)id);
    }

    @Override
    public CommonFileServerInfo update(CommonFileServerInfo commonFileServerInfo) throws Exception {
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={} update CommonFileServer info=[{}].", (Object)userName, (Object)commonFileServerInfo);
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(commonFileServerInfo.getId()));
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + commonFileServerInfo.getId()));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + commonFileServerInfo.getId()));
        if (commonFileServerInfo.getUsername() != null && !commonFileServerInfo.getUsername().equals(entity.getUsername())) {
            throw new IllegalArgumentException(entity.getId() + " username=" + entity.getUsername() + " can not be updated.");
        }
        if (commonFileServerInfo.getIp() != null && !commonFileServerInfo.getIp().equals(entity.getIp())) {
            throw new IllegalArgumentException(entity.getId() + " ip=" + entity.getIp() + " can not be updated.");
        }
        if (commonFileServerInfo.getPort() != 0 && commonFileServerInfo.getPort() != entity.getPort().intValue()) {
            throw new IllegalArgumentException(entity.getId() + " port = " + entity.getPort() + " can not be updated.");
        }
        commonFileServerInfo.setPort(entity.getPort().intValue());
        this.checkStrFieldLength(commonFileServerInfo);
        if (!this.checkCreator(userName, entity)) {
            throw new IllegalArgumentException(userName + " is not creator, has no right to update id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        CommonFileServerEntity record = new CommonFileServerEntity();
        BeanUtils.copyProperties((Object)commonFileServerInfo, (Object)record);
        record.setIsDeleted(null);
        record.setCreateTime(null);
        Date now = new Date();
        record.setModifier(userName);
        record.setModifyTime(now);
        int success = this.commonFileServerMapper.updateByPrimaryKeySelective(record);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("Database update id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success update CommonFileServer id={}", (Object)userName, (Object)entity.getId());
        return CommonFileServerInfoBuilder.buildFileInfoFromEntity(this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(commonFileServerInfo.getId())));
    }

    @Override
    public CommonFileServerInfo freeze(int id) throws Exception {
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={} freeze CommonFileServer id=[{}].", (Object)userName, (Object)id);
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(id));
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(userName, entity)) {
            throw new IllegalArgumentException(userName + " is not creator, has no right to freeze id=" + id + ", please contact " + entity.getCreator());
        }
        Date now = new Date();
        entity.setId(Integer.valueOf(id));
        entity.setModifier(userName);
        entity.setModifyTime(now);
        entity.setStatus(Integer.valueOf(1));
        int success = this.commonFileServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("Database update id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success freeze CommonFileServer id={}", (Object)userName, (Object)entity.getId());
        return CommonFileServerInfoBuilder.buildFileInfoFromEntity(this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(id)));
    }

    @Override
    public CommonFileServerInfo unfreeze(int id) throws Exception {
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={} unfreeze CommonFileServer id=[{}].", (Object)userName, (Object)id);
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(id));
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(userName, entity)) {
            throw new IllegalArgumentException(userName + " is not creator, has no right to unfreeze id=" + id + ", please contact " + entity.getCreator());
        }
        Date now = new Date();
        entity.setId(Integer.valueOf(id));
        entity.setModifier(userName);
        entity.setModifyTime(now);
        entity.setStatus(Integer.valueOf(0));
        int success = this.commonFileServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success unfreeze CommonFileServer id={}", (Object)userName, (Object)entity.getId());
        return CommonFileServerInfoBuilder.buildFileInfoFromEntity(this.commonFileServerMapper.selectByPrimaryKey(Integer.valueOf(id)));
    }

    @Override
    public List<CommonFileServerInfo> getByUser(String user) throws Exception {
        List all = this.commonFileServerMapper.selectAll();
        List<String> groups = this.getUserGroups(user);
        ArrayList<CommonFileServerInfo> results = new ArrayList<CommonFileServerInfo>();
        Splitter commaSplitter = Splitter.on((char)',');
        for (CommonFileServerEntity entry : all) {
            List vGroup;
            if (entry.getCreator().equals(user)) {
                results.add(CommonFileServerInfoBuilder.buildFileInfoFromEntity(entry));
                continue;
            }
            List vPersion = commaSplitter.splitToList((CharSequence)entry.getVisiblePerson());
            if (!this.checkUserVisible(user, groups, vPersion, vGroup = commaSplitter.splitToList((CharSequence)entry.getVisibleGroup()))) continue;
            results.add(CommonFileServerInfoBuilder.buildFileInfoFromEntity(entry));
        }
        return results;
    }

    private boolean checkUserVisible(String user, List<String> groups, List<String> vPersion, List<String> vGroup) {
        for (String persion : vPersion) {
            if (!persion.equals(user)) continue;
            return true;
        }
        for (String group : vGroup) {
            for (String g : groups) {
                if (!group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CommonFileServerInfo addVisiblePerson(Integer id, String visiblePerson) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, add visible person, id={}, visible group={}", new Object[]{username, id, visiblePerson});
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to addVisiblePerson id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List adds = commaSplitter.splitToList((CharSequence)visiblePerson);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisiblePerson());
        HashSet all = new HashSet();
        all.addAll(alreadyExists);
        all.addAll(adds);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisiblePerson(result);
        if (CommonFileServerServiceImpl.checkStrLen(entity.getVisiblePerson(), 1024)) {
            throw new IllegalArgumentException("CommonFileServer visiblePerson = [" + entity.getVisiblePerson() + "] length is " + entity.getVisiblePerson().length() + " and too large, The maximum size for the field length is 1024.");
        }
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonFileServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success addVisiblePerson for CommonFileServer id={}", (Object)username, (Object)entity.getId());
        return CommonFileServerInfoBuilder.buildFileInfoFromEntity(this.commonFileServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public CommonFileServerInfo deleteVisiblePerson(Integer id, String visiblePerson) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, delete visible person, id={}, visible group={}", new Object[]{username, id, visiblePerson});
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to deleteVisiblePerson id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List removes = commaSplitter.splitToList((CharSequence)visiblePerson);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisiblePerson());
        HashSet all = new HashSet(alreadyExists);
        removes.forEach(all::remove);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisiblePerson(result);
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonFileServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success deleteVisiblePerson for CommonFileServer id={}", (Object)username, (Object)entity.getId());
        return CommonFileServerInfoBuilder.buildFileInfoFromEntity(this.commonFileServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public CommonFileServerInfo addVisibleGroup(Integer id, String visibleGroup) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, add visible group, id={}, visible group={}", new Object[]{username, id, visibleGroup});
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to addVisibleGroup id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List adds = commaSplitter.splitToList((CharSequence)visibleGroup);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisibleGroup());
        HashSet all = new HashSet();
        all.addAll(alreadyExists);
        all.addAll(adds);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisibleGroup(result);
        if (CommonFileServerServiceImpl.checkStrLen(entity.getVisibleGroup(), 1024)) {
            throw new IllegalArgumentException("CommonFileServer visibleGroup = [" + entity.getVisibleGroup() + "] length is " + entity.getVisibleGroup().length() + " and too large, The maximum size for the field length is 1024.");
        }
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonFileServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success addVisibleGroup for CommonFileServer id={}", (Object)username, (Object)entity.getId());
        return CommonFileServerInfoBuilder.buildFileInfoFromEntity(this.commonFileServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public CommonFileServerInfo deleteVisibleGroup(Integer id, String visibleGroup) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, delete visible group, id={}, visible group={}", new Object[]{username, id, visibleGroup});
        CommonFileServerEntity entity = this.commonFileServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonFileServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonFileServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to deleteVisibleGroup id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List removes = commaSplitter.splitToList((CharSequence)visibleGroup);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisibleGroup());
        HashSet all = new HashSet(alreadyExists);
        removes.forEach(all::remove);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisibleGroup(result);
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonFileServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success deleteVisibleGroup for CommonFileServer id={}", (Object)username, (Object)entity.getId());
        return CommonFileServerInfoBuilder.buildFileInfoFromEntity(this.commonFileServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public PageInfo<CommonFileServerListVo> listByCondition(CommonFileServerPageRequest request) throws Exception {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        request.setCurrentUser(username);
        LOGGER.debug("{} begin to list CommonFileServer info by {}", (Object)username, (Object)request);
        List<String> groups = this.getUserGroups(username);
        request.setUserGroups(groups);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page pageResult = (Page)this.commonFileServerMapper.selectByCondition(request);
        PageInfo pageInfo = pageResult.toPageInfo(entity -> (CommonFileServerListVo)CommonBeanUtils.copyProperties((Object)entity, CommonFileServerListVo::new));
        pageInfo.setTotal(pageResult.getTotal());
        return pageInfo;
    }

    private List<String> getUserGroups(String userName) {
        return new ArrayList<String>();
    }

    private boolean checkVisible(String userName, CommonFileServerEntity entity) {
        boolean passed = false;
        boolean bl = passed = passed || this.checkCreator(userName, entity);
        if (!passed) {
            boolean bl2 = passed = passed || this.checkVisiblePerson(userName, entity);
            if (!passed) {
                passed = passed || this.checkVisibleGroup(userName, entity);
            }
        }
        return passed;
    }

    private boolean checkCreator(String username, CommonFileServerEntity entity) {
        return entity.getCreator().equals(username);
    }

    private boolean checkVisiblePerson(String username, CommonFileServerEntity entity) {
        return this.contains(username, entity.getVisiblePerson());
    }

    private boolean contains(String name, String visibles) {
        if (visibles == null || visibles.isEmpty()) {
            return false;
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        for (String entry : commaSplitter.split((CharSequence)visibles)) {
            if (!entry.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean checkVisibleGroup(String username, CommonFileServerEntity entity) {
        String visibleGroup = entity.getVisibleGroup();
        if (visibleGroup == null || visibleGroup.isEmpty()) {
            return false;
        }
        List<String> groups = this.getUserGroups(username);
        for (String group : groups) {
            if (!this.contains(group, visibleGroup)) continue;
            return true;
        }
        return false;
    }
}

