/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.ClusterInfoEntity;
import org.apache.inlong.manager.dao.mapper.ClusterInfoMapper;
import org.apache.inlong.manager.service.core.ClusterInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusterInfoServiceImpl
implements ClusterInfoService {
    private static final Logger log = LoggerFactory.getLogger(ClusterInfoServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterInfoServiceImpl.class);
    @Autowired
    private ClusterInfoMapper clusterInfoMapper;

    @Override
    public List<String> listClusterIpByType(String type) {
        ClusterRequest request = ClusterRequest.builder().type(type).build();
        List clusterInfoEntities = this.clusterInfoMapper.selectByCondition(request);
        ArrayList<String> ipList = new ArrayList<String>(clusterInfoEntities.size());
        for (ClusterInfoEntity entity : clusterInfoEntities) {
            ipList.add(entity.getIp());
        }
        return ipList;
    }

    @Override
    public List<ClusterInfo> list(ClusterRequest request) {
        LOGGER.info("begin to list cluster by request={}", (Object)request);
        List entityList = this.clusterInfoMapper.selectByCondition(request);
        List infoList = CommonBeanUtils.copyListProperties((List)entityList, ClusterInfo::new);
        LOGGER.info("success to get cluster");
        return infoList;
    }

    @Override
    public List<ClusterInfo> getClusterInfoByIdList(List<Integer> clusterIdList) {
        if (CollectionUtils.isEmpty(clusterIdList)) {
            return Collections.emptyList();
        }
        List entityList = this.clusterInfoMapper.selectByIdList(clusterIdList);
        return CommonBeanUtils.copyListProperties((List)entityList, ClusterInfo::new);
    }
}

