/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamSummaryInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowResult;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.service.workflow.newbusiness.NewBusinessWorkflowForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessProcessOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessProcessOperation.class);
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private DataStreamService streamService;
    @Autowired
    private StorageService storageService;

    public WorkflowResult startProcess(String bid, String operator) {
        LOGGER.info("begin to start approve process, bid={}", (Object)bid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(bid);
        if (entity == null) {
            LOGGER.error("business not found by bid={}", (Object)bid);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        Preconditions.checkTrue((boolean)EntityStatus.ALLOW_START_WORKFLOW_STATUS.contains(entity.getStatus()), (String)"current status was not allowed to start workflow");
        entity.setModifier(operator);
        entity.setModifyTime(new Date());
        entity.setStatus(EntityStatus.BIZ_WAIT_APPROVAL.getCode());
        int success = this.businessMapper.updateByIdentifierSelective(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"failed to update business during assign and start process");
        BusinessInfo businessInfo = (BusinessInfo)CommonBeanUtils.copyProperties((Object)entity, BusinessInfo::new);
        NewBusinessWorkflowForm form = this.genNewBusinessWorkflowForm(businessInfo);
        return this.workflowService.start(ProcessName.NEW_BUSINESS_WORKFLOW, operator, form);
    }

    public NewBusinessWorkflowForm genNewBusinessWorkflowForm(BusinessInfo businessInfo) {
        NewBusinessWorkflowForm form = new NewBusinessWorkflowForm();
        form.setBusinessInfo(businessInfo);
        List<DataStreamSummaryInfo> infoList = this.streamService.getSummaryList(businessInfo.getBusinessIdentifier());
        form.setStreamInfoList(infoList);
        return form;
    }
}

