/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LightWeightDelayedSet<E extends Comparable<E>>
extends AbstractSet<E>
implements Collection<E> {
    private long delayedTime;
    private int capacity = 16;
    private int initialCapacity = 16;
    private float maxLoadFactor = 0.75f;
    private float minLoadFactor = 0.2f;
    private Map<DelayedCarrier<E>, E> innerMap;

    public LightWeightDelayedSet(long delayedTime) {
        this(delayedTime, 16, 0.75f, 0.2f);
    }

    public LightWeightDelayedSet(long delayedTime, int initialCapacity, float maxLoadFactor, float minLoadFactor) {
        this.delayedTime = delayedTime;
        this.maxLoadFactor = maxLoadFactor;
        this.minLoadFactor = minLoadFactor;
        this.initialCapacity = this.capacity = this.grow(initialCapacity);
        this.innerMap = new LinkedHashMap<DelayedCarrier<E>, E>(this.capacity, this.maxLoadFactor);
    }

    public void adjustTime(long offset) {
        this.delayedTime = offset;
    }

    public void drainTo(Collection<E> collection) {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
            iterator.remove();
        }
    }

    public List<E> pollN(int n) {
        Map.Entry<DelayedCarrier<E>, E> entry;
        ArrayList<E> elements = new ArrayList<E>();
        Iterator<Map.Entry<DelayedCarrier<E>, E>> iterator = this.innerMap.entrySet().iterator();
        int idx = 0;
        while (iterator.hasNext() && idx++ < n && (entry = iterator.next()).getKey().getStartTime() + this.delayedTime <= System.currentTimeMillis()) {
            iterator.remove();
            elements.add(entry.getValue());
        }
        if (this.innerMap.size() > this.initialCapacity && !elements.isEmpty() && (float)this.innerMap.size() < (float)this.capacity * this.minLoadFactor) {
            this.shrink();
        }
        return elements;
    }

    private void shrink() {
        Map<DelayedCarrier<E>, E> tempMap = this.innerMap;
        int capacity = this.grow(tempMap.size());
        if ((float)tempMap.size() > (float)capacity * this.maxLoadFactor) {
            capacity = this.grow((int)((float)capacity * this.maxLoadFactor));
        }
        this.capacity = capacity;
        this.innerMap = new LinkedHashMap<DelayedCarrier<E>, E>(capacity, this.maxLoadFactor);
        for (Map.Entry<DelayedCarrier<E>, E> entry : tempMap.entrySet()) {
            this.innerMap.put(entry.getKey(), entry.getValue());
        }
        tempMap = null;
    }

    public List<E> pollN() {
        return this.pollN(Integer.MAX_VALUE);
    }

    public E poll() {
        List<E> elements = this.pollN(1);
        return (E)(elements != null && elements.size() == 1 ? (Comparable)elements.get(0) : null);
    }

    public E getElement(E item) {
        if (this.innerMap.isEmpty()) {
            return null;
        }
        DelayedCarrier<?> obj = this.wrapper(item);
        return (E)((Comparable)this.innerMap.get(obj));
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.innerMap.keySet().iterator(), (Function)new Function<DelayedCarrier<E>, E>(){

            public E apply(DelayedCarrier<E> input) {
                return (Comparable)input.get();
            }
        });
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof DelayedCarrier)) {
            o = this.wrapper(o);
        }
        return this.innerMap.get(o) != null;
    }

    private DelayedCarrier<?> wrapper(Object o) {
        return new DelayedCarrier<Object>(o, -1L);
    }

    @Override
    public Object[] toArray() {
        return this.innerMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.innerMap.values().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.add(new DelayedCarrier<E>(e, System.currentTimeMillis()));
    }

    private int grow(int target) {
        int capacity;
        for (capacity = 1; capacity < target; capacity <<= 1) {
        }
        return capacity;
    }

    @Override
    private boolean add(DelayedCarrier<E> carrier) {
        Comparable previous = (Comparable)this.innerMap.put(carrier, carrier.get());
        int size = this.innerMap.size();
        if ((float)size > (float)this.capacity * this.maxLoadFactor) {
            this.capacity = this.grow(size + 1);
        }
        return previous == null;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof DelayedCarrier)) {
            o = this.wrapper(o);
        }
        return this.innerMap.remove(o) != null;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append("(size=").append(this.innerMap.size()).append(")");
        return b.toString();
    }

    public void setDelayTime(long delayTime) {
        this.delayedTime = delayTime;
    }

    public static class DelayedCarrier<E> {
        private long startTime;
        private E e;

        public DelayedCarrier(E e, long createTime) {
            this.e = e;
            this.startTime = createTime;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DelayedCarrier)) {
                return false;
            }
            return this.get().equals(((DelayedCarrier)obj).get());
        }

        public static <E extends Comparable<E>> Set<DelayedCarrier<E>> asSet(long triggerTime, Collection<E> c) {
            if (c != null) {
                HashSet<DelayedCarrier<DelayedCarrier<Comparable>>> dSet = new HashSet<DelayedCarrier<DelayedCarrier<Comparable>>>();
                for (Comparable e : c) {
                    dSet.add(new DelayedCarrier<Comparable>(e, triggerTime));
                }
                return dSet;
            }
            return Collections.emptySet();
        }

        public int hashCode() {
            return this.get().hashCode();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void offset(long offset) {
            this.startTime += offset;
        }

        public E get() {
            return this.e;
        }

        public String toString() {
            return "startTime+" + this.startTime + "ms,element:" + this.e.toString();
        }
    }
}

