/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class DFSck
extends Configured
implements Tool {
    private static final String USAGE = "Usage: DFSck <path> [-list-corruptfileblocks | [-move | -delete | -openforwrite] [-files [-blocks [-locations | -racks]]]]\n\t<path>\tstart checking from this path\n\t-move\tmove corrupted files to /lost+found\n\t-delete\tdelete corrupted files\n\t-files\tprint out files being checked\n\t-openforwrite\tprint out files opened for write\n\t-list-corruptfileblocks\tprint out list of missing blocks and files they belong to\n\t-blocks\tprint out block report\n\t-locations\tprint out locations for every block\n\t-racks\tprint out network topology for data-node locations\n\t\tBy default fsck ignores files opened for write, use -openforwrite to report such files. They are usually  tagged CORRUPT or HEALTHY depending on their block allocation status";
    private final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
    private final PrintStream out;

    public DFSck(Configuration conf) throws IOException {
        this(conf, System.out);
    }

    public DFSck(Configuration conf, PrintStream out) throws IOException {
        super(conf);
        this.out = out;
    }

    static void printUsage(PrintStream out) {
        out.println("Usage: DFSck <path> [-list-corruptfileblocks | [-move | -delete | -openforwrite] [-files [-blocks [-locations | -racks]]]]\n\t<path>\tstart checking from this path\n\t-move\tmove corrupted files to /lost+found\n\t-delete\tdelete corrupted files\n\t-files\tprint out files being checked\n\t-openforwrite\tprint out files opened for write\n\t-list-corruptfileblocks\tprint out list of missing blocks and files they belong to\n\t-blocks\tprint out block report\n\t-locations\tprint out locations for every block\n\t-racks\tprint out network topology for data-node locations\n\t\tBy default fsck ignores files opened for write, use -openforwrite to report such files. They are usually  tagged CORRUPT or HEALTHY depending on their block allocation status\n");
        ToolRunner.printGenericCommandUsage((PrintStream)out);
    }

    public int run(final String[] args) throws IOException {
        if (args.length == 0) {
            DFSck.printUsage(System.err);
            return -1;
        }
        try {
            return (Integer)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return DFSck.this.doWork(args);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer listCorruptFileBlocks(String dir, int limit, String baseUrl) throws IOException {
        int errCode = -1;
        int numCorrupt = 0;
        int cookie = 0;
        String noCorruptLine = "has no CORRUPT files";
        String noMoreCorruptLine = "has no more CORRUPT files";
        String cookiePrefix = "Cookie:";
        boolean allDone = false;
        block5: while (!allDone) {
            StringBuffer url = new StringBuffer(baseUrl);
            if (cookie > 0) {
                url.append("&startblockafter=").append(String.valueOf(cookie));
            }
            URL path = new URL(url.toString());
            URLConnection connection = SecurityUtil.openSecureHttpConnection((URL)path);
            InputStream stream = connection.getInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (line.startsWith("Cookie:")) {
                        try {
                            cookie = Integer.parseInt(line.split("\t")[1]);
                            continue;
                        }
                        catch (Exception e) {
                            allDone = true;
                            continue block5;
                        }
                    }
                    if (line.endsWith("has no CORRUPT files") || line.endsWith("has no more CORRUPT files") || line.endsWith("does not exist") || numCorrupt >= limit) {
                        allDone = true;
                        continue block5;
                    }
                    if (line.isEmpty() || line.startsWith("FSCK started by") || line.startsWith("The filesystem under path")) continue;
                    if (++numCorrupt == 1) {
                        this.out.println("The list of corrupt files under path '" + dir + "' are:");
                    }
                    this.out.println(line);
                }
            }
            finally {
                input.close();
            }
        }
        this.out.println("The filesystem under path '" + dir + "' has " + numCorrupt + " CORRUPT files");
        if (numCorrupt == 0) {
            errCode = 0;
        }
        return errCode;
    }

    private String getCurrentNamenodeAddress() throws IOException {
        FileSystem fs;
        Configuration conf = this.getConf();
        try {
            fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException ioe) {
            System.err.println("FileSystem is inaccessible due to:\n" + StringUtils.stringifyException((Throwable)ioe));
            return null;
        }
        if (!(fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + fs.getUri());
            return null;
        }
        return DFSUtil.getInfoServer(HAUtil.getAddressOfActive(fs), conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWork(String[] args) throws IOException {
        StringBuilder url = new StringBuilder(HttpConfig.getSchemePrefix());
        String namenodeAddress = this.getCurrentNamenodeAddress();
        if (namenodeAddress == null) {
            System.err.println("DFSck exiting.");
            return 0;
        }
        url.append(namenodeAddress);
        System.err.println("Connecting to namenode via " + url.toString());
        url.append("/fsck?ugi=").append(this.ugi.getShortUserName());
        String dir = null;
        int limit = 500;
        boolean doListCorruptFileBlocks = false;
        for (int idx = 0; idx < args.length; ++idx) {
            if (args[idx].equals("-move")) {
                url.append("&move=1");
                continue;
            }
            if (args[idx].equals("-delete")) {
                url.append("&delete=1");
                continue;
            }
            if (args[idx].equals("-files")) {
                url.append("&files=1");
                continue;
            }
            if (args[idx].equals("-openforwrite")) {
                url.append("&openforwrite=1");
                continue;
            }
            if (args[idx].equals("-blocks")) {
                url.append("&blocks=1");
                continue;
            }
            if (args[idx].equals("-locations")) {
                url.append("&locations=1");
                continue;
            }
            if (args[idx].equals("-racks")) {
                url.append("&racks=1");
                continue;
            }
            if (args[idx].equals("-list-corruptfileblocks")) {
                url.append("&listcorruptfileblocks=1");
                doListCorruptFileBlocks = true;
                continue;
            }
            if (args[idx].equals("-limit")) {
                limit = Integer.parseInt(args[++idx]);
                continue;
            }
            if (args[idx].equals("-list-decommissioningblocks")) {
                url.append("&decommissioning=1");
                continue;
            }
            if (!args[idx].startsWith("-")) {
                if (null == dir) {
                    dir = args[idx];
                    continue;
                }
                System.err.println("fsck: can only operate on one path at a time '" + args[idx] + "'");
                DFSck.printUsage(System.err);
                return -1;
            }
            System.err.println("fsck: Illegal option '" + args[idx] + "'");
            DFSck.printUsage(System.err);
            return -1;
        }
        if (null == dir) {
            dir = "/";
        }
        url.append("&path=").append(URLEncoder.encode(dir, "UTF-8"));
        if (doListCorruptFileBlocks) {
            return this.listCorruptFileBlocks(dir, limit, url.toString());
        }
        URL path = new URL(url.toString());
        URLConnection connection = SecurityUtil.openSecureHttpConnection((URL)path);
        InputStream stream = connection.getInputStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = null;
        String lastLine = null;
        int errCode = -1;
        try {
            while ((line = input.readLine()) != null) {
                this.out.println(line);
                lastLine = line;
            }
        }
        finally {
            input.close();
        }
        if (lastLine.endsWith("is HEALTHY")) {
            errCode = 0;
        } else if (lastLine.endsWith("is CORRUPT")) {
            errCode = 1;
        } else if (lastLine.endsWith("does not exist")) {
            errCode = 0;
        }
        return errCode;
    }

    public static void main(String[] args) throws Exception {
        int res = -1;
        if (args.length == 0 || "-files".equals(args[0])) {
            DFSck.printUsage(System.err);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        } else {
            res = DFSUtil.parseHelpArgument(args, USAGE, System.out, true) ? 0 : ToolRunner.run((Tool)new DFSck(new HdfsConfiguration()), (String[])args);
        }
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
    }
}

