/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class ConfiguredFailoverProxyProvider<T>
implements FailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(ConfiguredFailoverProxyProvider.class);
    private final Configuration conf;
    private final List<AddressRpcProxyPair<T>> proxies = new ArrayList<AddressRpcProxyPair<T>>();
    private final UserGroupInformation ugi;
    private final Class<T> xface;
    private int currentProxyIndex = 0;
    private Boolean fileCacheEnable = false;
    private File addressCacheFile = null;
    private String fileCachePathName = "";
    private URI uri = null;
    private Boolean isCheckDNS = false;

    public ConfiguredFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface) {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(NamenodeProtocols.class), (Object)"Interface class %s is not a valid NameNode protocol!");
        this.xface = xface;
        this.conf = new Configuration(conf);
        this.uri = uri;
        this.fileCacheEnable = conf.getBoolean("dfs.namenode.ha.client.file.cache.enable", true);
        this.isCheckDNS = conf.getBoolean("tdw.support.change.dns", false);
        String confFilePath = conf.get("dfs.namenode.ha.client.file.cache.path", "/tmp");
        this.fileCachePathName = confFilePath + "/" + uri.getHost();
        this.addressCacheFile = new File(this.fileCachePathName);
        int maxRetries = this.conf.getInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
        int maxRetriesOnSocketTimeouts = this.conf.getInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", maxRetriesOnSocketTimeouts);
        try {
            this.ugi = UserGroupInformation.getCurrentUserWithPW((Configuration)conf);
            LOG.debug((Object)("get ugi user:" + this.ugi.getShortUserName()));
            Map<String, Map<String, InetSocketAddress>> map = DFSUtil.getHaNnRpcAddresses(conf);
            Map<String, InetSocketAddress> addressesInNN = map.get(uri.getHost());
            if (addressesInNN == null || addressesInNN.size() == 0) {
                throw new RuntimeException("Could not find any configured addresses for URI " + uri);
            }
            String activeAddress = this.getActvieAddressFromDiskCache();
            Collection<InetSocketAddress> addressesOfNns = addressesInNN.values();
            int number = 0;
            for (InetSocketAddress address : addressesOfNns) {
                this.proxies.add(new AddressRpcProxyPair(address));
                if (address != null && activeAddress != null && address.getHostString().equals(activeAddress)) {
                    this.currentProxyIndex = number;
                }
                ++number;
            }
            HAUtil.cloneDelegationTokenForLogicalUri(this.ugi, uri, addressesOfNns);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<T> getInterface() {
        return this.xface;
    }

    public synchronized T getProxy() {
        AddressRpcProxyPair<T> current = this.proxies.get(this.currentProxyIndex);
        if (current.namenode == null) {
            try {
                current.namenode = NameNodeProxies.createNonHAProxy(this.conf, current.address, this.xface, this.ugi, false).getProxy();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to create RPC proxy to NameNode", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return current.namenode;
    }

    public synchronized void performFailover(T currentProxy) {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.proxies.size();
        AddressRpcProxyPair<T> tmpProxy = this.proxies.get(this.currentProxyIndex);
        this.saveToDiskCache(tmpProxy);
        if (this.isCheckDNS.booleanValue()) {
            this.checkDNSAddressChange(tmpProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDNSAddressChange(AddressRpcProxyPair<T> proxy) {
        InetSocketAddress isa = NetUtils.createSocketAddr((String)proxy.address.getHostString());
        if (!isa.getAddress().equals(proxy.address.getAddress())) {
            proxy.address = isa;
            LOG.info((Object)("change ip : " + proxy.address.getAddress() + " to : " + isa.getAddress()));
            try {
                if (proxy.namenode != null) {
                    if (proxy.namenode instanceof Closeable) {
                        ((Closeable)proxy.namenode).close();
                    } else {
                        RPC.stopProxy(proxy.namenode);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"close namenode proxy error!", (Throwable)e);
            }
            finally {
                proxy.namenode = null;
            }
        }
    }

    public synchronized void close() throws IOException {
        for (AddressRpcProxyPair<T> proxy : this.proxies) {
            if (proxy.namenode == null) continue;
            if (proxy.namenode instanceof Closeable) {
                ((Closeable)proxy.namenode).close();
                continue;
            }
            RPC.stopProxy(proxy.namenode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDiskCache(AddressRpcProxyPair<T> proxy) {
        if (!this.fileCacheEnable.booleanValue()) {
            return;
        }
        File file = this.addressCacheFile;
        synchronized (file) {
            boolean isExists = this.addressCacheFile.exists();
            RandomAccessFile fis = null;
            FileChannel fc = null;
            FileLock lock = null;
            try {
                fis = new RandomAccessFile(this.addressCacheFile, "rw");
                fc = fis.getChannel();
                lock = fc.tryLock();
                if (lock != null) {
                    fc.truncate(0L);
                    if (proxy != null && proxy.address != null) {
                        fis.writeBytes(proxy.address.getHostString());
                    }
                } else {
                    LOG.debug((Object)"Unable get file lock when saveToDiskCache.");
                    return;
                }
                if (!isExists) {
                    FileUtil.setPermission((File)this.addressCacheFile, (FsPermission)FsPermission.getDefault());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"saveToDiskCache failed!", (Throwable)e);
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"release lock error!", (Throwable)e);
                }
                try {
                    if (fc != null) {
                        fc.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"close FileChannel error!", (Throwable)e);
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"close file error!", (Throwable)e);
                }
            }
        }
        LOG.debug((Object)("save address :" + proxy.address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public String getActvieAddressFromDiskCache() {
        if (!this.fileCacheEnable.booleanValue()) {
            return null;
        }
        String cacheAddress = "";
        File file = this.addressCacheFile;
        synchronized (file) {
            block46: {
                String string;
                RandomAccessFile fis = null;
                AbstractInterruptibleChannel fc = null;
                FileLock lock = null;
                try {
                    if (!this.addressCacheFile.exists()) {
                        LOG.warn((Object)("file " + this.addressCacheFile.getAbsolutePath() + " is not exits when loadFromDiskCache."));
                        String string2 = null;
                        return string2;
                    }
                    fis = new RandomAccessFile(this.addressCacheFile, "rw");
                    fc = fis.getChannel();
                    lock = ((FileChannel)fc).tryLock();
                    if (lock != null) {
                        cacheAddress = fis.readLine();
                        break block46;
                    }
                    LOG.warn((Object)"Unable get file lock when loadFromDiskCache.");
                    string = null;
                }
                catch (Exception e) {
                    LOG.warn((Object)"loadFromDiskCache failed!", (Throwable)e);
                    break block46;
                }
                finally {
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"release lock error!", (Throwable)e);
                    }
                    try {
                        if (fc != null) {
                            fc.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"close FileChannel error!", (Throwable)e);
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"close replicaViewFile error!", (Throwable)e);
                    }
                }
                return string;
            }
        }
        if (cacheAddress != null && !cacheAddress.isEmpty()) {
            LOG.debug((Object)("load address from disk:" + cacheAddress));
            return cacheAddress;
        }
        LOG.warn((Object)("Unable load replica from disk " + this.addressCacheFile.getAbsolutePath()));
        return null;
    }

    private static class AddressRpcProxyPair<T> {
        public InetSocketAddress address;
        public T namenode;

        public AddressRpcProxyPair(InetSocketAddress address) {
            this.address = address;
        }
    }
}

