/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;

@InterfaceAudience.Private
public class DNConf {
    final int socketTimeout;
    final int socketWriteTimeout;
    final int socketKeepaliveTimeout;
    final boolean transferToAllowed;
    final boolean dropCacheBehindWrites;
    final boolean syncBehindWrites;
    final boolean dropCacheBehindReads;
    final boolean syncOnClose;
    final boolean encryptDataTransfer;
    final boolean connectToDnViaHostname;
    final long readaheadLength;
    final long heartBeatInterval;
    final long blockReportInterval;
    final long deleteReportInterval;
    final long initialBlockReportDelay;
    final int writePacketSize;
    final String minimumNameNodeVersion;
    final String encryptionAlgorithm;
    final long xceiverStopTimeout;

    public DNConf(Configuration conf) {
        this.socketTimeout = conf.getInt("dfs.client.socket-timeout", HdfsServerConstants.READ_TIMEOUT);
        this.socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", HdfsServerConstants.WRITE_TIMEOUT);
        this.socketKeepaliveTimeout = conf.getInt("dfs.datanode.socket.reuse.keepalive", 1000);
        this.transferToAllowed = conf.getBoolean("dfs.datanode.transferTo.allowed", true);
        this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
        this.readaheadLength = conf.getLong("dfs.datanode.readahead.bytes", 0x400000L);
        this.dropCacheBehindWrites = conf.getBoolean("dfs.datanode.drop.cache.behind.writes", false);
        this.syncBehindWrites = conf.getBoolean("dfs.datanode.sync.behind.writes", false);
        this.dropCacheBehindReads = conf.getBoolean("dfs.datanode.drop.cache.behind.reads", false);
        this.connectToDnViaHostname = conf.getBoolean("dfs.datanode.use.datanode.hostname", false);
        this.blockReportInterval = conf.getLong("dfs.blockreport.intervalMsec", 3600000L);
        long initBRDelay = conf.getLong("dfs.blockreport.initialDelay", 0L) * 1000L;
        if (initBRDelay >= this.blockReportInterval) {
            initBRDelay = 0L;
            DataNode.LOG.info((Object)"dfs.blockreport.initialDelay is greater than dfs.blockreport.intervalMsec. Setting initial delay to 0 msec:");
        }
        this.initialBlockReportDelay = initBRDelay;
        this.heartBeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        this.deleteReportInterval = (long)conf.getInt("dfs.deleted.blockreport.interval.multipleof.heatbeat", 100) * this.heartBeatInterval;
        this.syncOnClose = conf.getBoolean("dfs.datanode.synconclose", false);
        this.minimumNameNodeVersion = conf.get("dfs.datanode.min.supported.namenode.version", "2.1.0-beta");
        this.encryptDataTransfer = conf.getBoolean("dfs.encrypt.data.transfer", false);
        this.encryptionAlgorithm = conf.get("dfs.encrypt.data.transfer.algorithm");
        this.xceiverStopTimeout = conf.getLong("dfs.datanode.xceiver.stop.timeout.millis", 60000L);
    }

    String getMinimumNameNodeVersion() {
        return this.minimumNameNodeVersion;
    }

    public long getXceiverStopTimeout() {
        return this.xceiverStopTimeout;
    }
}

