/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
public abstract class Storage
extends StorageInfo {
    public static final Log LOG = LogFactory.getLog((String)Storage.class.getName());
    public static final int LAST_PRE_UPGRADE_LAYOUT_VERSION = -3;
    public static final int LAST_UPGRADABLE_LAYOUT_VERSION = -16;
    protected static final String LAST_UPGRADABLE_HADOOP_VERSION = "Hadoop-0.18";
    public static final int[] LAYOUT_VERSIONS_203 = new int[]{-19, -31};
    public static final String STORAGE_FILE_LOCK = "in_use.lock";
    protected static final String STORAGE_FILE_VERSION = "VERSION";
    public static final String STORAGE_DIR_CURRENT = "current";
    public static final String STORAGE_DIR_PREVIOUS = "previous";
    public static final String STORAGE_TMP_REMOVED = "removed.tmp";
    public static final String STORAGE_TMP_PREVIOUS = "previous.tmp";
    public static final String STORAGE_TMP_FINALIZED = "finalized.tmp";
    public static final String STORAGE_TMP_LAST_CKPT = "lastcheckpoint.tmp";
    public static final String STORAGE_PREVIOUS_CKPT = "previous.checkpoint";
    public static final String STORAGE_1_BBW = "blocksBeingWritten";
    protected HdfsServerConstants.NodeType storageType;
    protected List<StorageDirectory> storageDirs = new ArrayList<StorageDirectory>();

    public List<File> getFiles(StorageDirType dirType, String fileName) {
        Iterator<StorageDirectory> it;
        ArrayList<File> list = new ArrayList<File>();
        Iterator<StorageDirectory> iterator = it = dirType == null ? this.dirIterator() : this.dirIterator(dirType);
        while (it.hasNext()) {
            list.add(new File(it.next().getCurrentDir(), fileName));
        }
        return list;
    }

    public Iterator<StorageDirectory> dirIterator() {
        return this.dirIterator(null);
    }

    public Iterator<StorageDirectory> dirIterator(StorageDirType dirType) {
        return new DirIterator(dirType);
    }

    public Iterable<StorageDirectory> dirIterable(final StorageDirType dirType) {
        return new Iterable<StorageDirectory>(){

            @Override
            public Iterator<StorageDirectory> iterator() {
                return Storage.this.dirIterator(dirType);
            }
        };
    }

    public String listStorageDirectories() {
        StringBuilder buf = new StringBuilder();
        for (StorageDirectory sd : this.storageDirs) {
            buf.append(sd.getRoot() + "(" + sd.getStorageDirType() + ");");
        }
        return buf.toString();
    }

    protected Storage(HdfsServerConstants.NodeType type) {
        this.storageType = type;
    }

    protected Storage(HdfsServerConstants.NodeType type, StorageInfo storageInfo) {
        super(storageInfo);
        this.storageType = type;
    }

    public int getNumStorageDirs() {
        return this.storageDirs.size();
    }

    public StorageDirectory getStorageDir(int idx) {
        return this.storageDirs.get(idx);
    }

    public StorageDirectory getSingularStorageDir() {
        Preconditions.checkState((this.storageDirs.size() == 1 ? 1 : 0) != 0);
        return this.storageDirs.get(0);
    }

    protected void addStorageDir(StorageDirectory sd) {
        this.storageDirs.add(sd);
    }

    public abstract boolean isPreUpgradableLayout(StorageDirectory var1) throws IOException;

    private void checkOldLayoutStorage(StorageDirectory sd) throws IOException {
        if (this.isPreUpgradableLayout(sd)) {
            Storage.checkVersionUpgradable(0);
        }
    }

    public static void checkVersionUpgradable(int oldVersion) throws IOException {
        if (oldVersion > -16) {
            String msg = "*********** Upgrade is not supported from this  older version " + oldVersion + " of storage to the current version." + " Please upgrade to " + LAST_UPGRADABLE_HADOOP_VERSION + " or a later version and then upgrade to current" + " version. Old layout version is " + (oldVersion == 0 ? "'too old'" : "" + oldVersion) + " and latest layout version this software version can" + " upgrade from is " + -16 + ". ************";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    public static boolean confirmFormat(Iterable<? extends FormatConfirmable> items, boolean force, boolean interactive) throws IOException {
        for (FormatConfirmable formatConfirmable : items) {
            if (!formatConfirmable.hasSomeData()) continue;
            if (force) {
                System.err.println("Data exists in " + formatConfirmable + ". Formatting anyway.");
                continue;
            }
            if (!interactive) {
                System.err.println("Running in non-interactive mode, and data appears to exist in " + formatConfirmable + ". Not formatting.");
                return false;
            }
            if (ToolRunner.confirmPrompt((String)("Re-format filesystem in " + formatConfirmable + " ?"))) continue;
            System.err.println("Format aborted in " + formatConfirmable);
            return false;
        }
        return true;
    }

    protected void setFieldsFromProperties(Properties props, StorageDirectory sd) throws IOException {
        this.setLayoutVersion(props, sd);
        this.setNamespaceID(props, sd);
        this.setStorageType(props, sd);
        this.setcTime(props, sd);
        this.setClusterId(props, this.layoutVersion, sd);
    }

    protected void setPropertiesFromFields(Properties props, StorageDirectory sd) throws IOException {
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("storageType", this.storageType.toString());
        props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        if (this.versionSupportsFederation()) {
            props.setProperty("clusterID", this.clusterID);
        }
        props.setProperty("cTime", String.valueOf(this.cTime));
    }

    public void readProperties(StorageDirectory sd) throws IOException {
        Properties props = Storage.readPropertiesFile(sd.getVersionFile());
        this.setFieldsFromProperties(props, sd);
    }

    public void readPreviousVersionProperties(StorageDirectory sd) throws IOException {
        Properties props = Storage.readPropertiesFile(sd.getPreviousVersionFile());
        this.setFieldsFromProperties(props, sd);
    }

    public void writeProperties(StorageDirectory sd) throws IOException {
        this.writeProperties(sd.getVersionFile(), sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties(File to, StorageDirectory sd) throws IOException {
        Properties props = new Properties();
        this.setPropertiesFromFields(props, sd);
        RandomAccessFile file = new RandomAccessFile(to, "rws");
        FileOutputStream out = null;
        try {
            file.seek(0L);
            out = new FileOutputStream(file.getFD());
            props.store(out, null);
            file.setLength(out.getChannel().position());
        }
        finally {
            if (out != null) {
                out.close();
            }
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFile(File from) throws IOException {
        RandomAccessFile file = new RandomAccessFile(from, "rws");
        FileInputStream in = null;
        Properties props = new Properties();
        try {
            in = new FileInputStream(file.getFD());
            file.seek(0L);
            props.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
            file.close();
        }
        return props;
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Failed to rename " + from.getCanonicalPath() + " to " + to.getCanonicalPath());
        }
    }

    public static void deleteDir(File dir) throws IOException {
        if (!FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Failed to delete " + dir.getCanonicalPath());
        }
    }

    public void writeAll() throws IOException {
        this.layoutVersion = HdfsConstants.LAYOUT_VERSION;
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            this.writeProperties(it.next());
        }
    }

    public void unlockAll() throws IOException {
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            it.next().unlock();
        }
    }

    public static String getBuildVersion() {
        return VersionInfo.getRevision();
    }

    public static String getRegistrationID(StorageInfo storage) {
        return "NS-" + Integer.toString(storage.getNamespaceID()) + "-" + storage.getClusterID() + "-" + Integer.toString(storage.getLayoutVersion()) + "-" + Long.toString(storage.getCTime());
    }

    String getProperty(Properties props, StorageDirectory sd, String name) throws InconsistentFSStateException {
        String property = props.getProperty(name);
        if (property == null) {
            throw new InconsistentFSStateException(sd.root, "file VERSION has " + name + " missing.");
        }
        return property;
    }

    protected void setStorageType(Properties props, StorageDirectory sd) throws InconsistentFSStateException {
        HdfsServerConstants.NodeType type = HdfsServerConstants.NodeType.valueOf(this.getProperty(props, sd, "storageType"));
        if (!this.storageType.equals((Object)type)) {
            throw new InconsistentFSStateException(sd.root, "node type is incompatible with others.");
        }
        this.storageType = type;
    }

    protected void setcTime(Properties props, StorageDirectory sd) throws InconsistentFSStateException {
        this.cTime = Long.parseLong(this.getProperty(props, sd, "cTime"));
    }

    protected void setClusterId(Properties props, int layoutVersion, StorageDirectory sd) throws InconsistentFSStateException {
        if (LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, layoutVersion)) {
            String cid = this.getProperty(props, sd, "clusterID");
            if (!(this.clusterID.equals("") || cid.equals("") || this.clusterID.equals(cid))) {
                throw new InconsistentFSStateException(sd.getRoot(), "cluster Id is incompatible with others.");
            }
            this.clusterID = cid;
        }
    }

    protected void setLayoutVersion(Properties props, StorageDirectory sd) throws IncorrectVersionException, InconsistentFSStateException {
        int lv = Integer.parseInt(this.getProperty(props, sd, "layoutVersion"));
        if (lv < HdfsConstants.LAYOUT_VERSION) {
            throw new IncorrectVersionException(lv, "storage directory " + sd.root.getAbsolutePath());
        }
        this.layoutVersion = lv;
    }

    protected void setNamespaceID(Properties props, StorageDirectory sd) throws InconsistentFSStateException {
        int nsId = Integer.parseInt(this.getProperty(props, sd, "namespaceID"));
        if (this.namespaceID != 0 && nsId != 0 && this.namespaceID != nsId) {
            throw new InconsistentFSStateException(sd.root, "namespaceID is incompatible with others.");
        }
        this.namespaceID = nsId;
    }

    public static boolean is203LayoutVersion(int layoutVersion) {
        for (int lv203 : LAYOUT_VERSIONS_203) {
            if (lv203 != layoutVersion) continue;
            return true;
        }
        return false;
    }

    protected boolean containsStorageDir(File root) throws IOException {
        for (StorageDirectory sd : this.storageDirs) {
            if (!sd.getRoot().getCanonicalPath().equals(root.getCanonicalPath())) continue;
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    public static interface FormatConfirmable {
        public boolean hasSomeData() throws IOException;

        public String toString();
    }

    @InterfaceAudience.Private
    public static class StorageDirectory
    implements FormatConfirmable {
        final File root;
        final boolean useLock;
        final StorageDirType dirType;
        FileLock lock;

        public StorageDirectory(File dir) {
            this(dir, null, true);
        }

        public StorageDirectory(File dir, StorageDirType dirType) {
            this(dir, dirType, true);
        }

        public StorageDirectory(File dir, StorageDirType dirType, boolean useLock) {
            this.root = dir;
            this.lock = null;
            this.dirType = dirType;
            this.useLock = useLock;
        }

        public File getRoot() {
            return this.root;
        }

        public StorageDirType getStorageDirType() {
            return this.dirType;
        }

        public void read(File from, Storage storage) throws IOException {
            Properties props = Storage.readPropertiesFile(from);
            storage.setFieldsFromProperties(props, this);
        }

        public void clearDirectory() throws IOException {
            File curDir = this.getCurrentDir();
            if (curDir.exists() && !FileUtil.fullyDelete((File)curDir)) {
                throw new IOException("Cannot remove current directory: " + curDir);
            }
            if (!curDir.mkdirs()) {
                throw new IOException("Cannot create directory " + curDir);
            }
        }

        public File getCurrentDir() {
            return new File(this.root, Storage.STORAGE_DIR_CURRENT);
        }

        public File getVersionFile() {
            return new File(new File(this.root, Storage.STORAGE_DIR_CURRENT), Storage.STORAGE_FILE_VERSION);
        }

        public File getPreviousVersionFile() {
            return new File(new File(this.root, Storage.STORAGE_DIR_PREVIOUS), Storage.STORAGE_FILE_VERSION);
        }

        public File getPreviousDir() {
            return new File(this.root, Storage.STORAGE_DIR_PREVIOUS);
        }

        public File getPreviousTmp() {
            return new File(this.root, Storage.STORAGE_TMP_PREVIOUS);
        }

        public File getRemovedTmp() {
            return new File(this.root, Storage.STORAGE_TMP_REMOVED);
        }

        public File getFinalizedTmp() {
            return new File(this.root, Storage.STORAGE_TMP_FINALIZED);
        }

        public File getLastCheckpointTmp() {
            return new File(this.root, Storage.STORAGE_TMP_LAST_CKPT);
        }

        public File getPreviousCheckpoint() {
            return new File(this.root, Storage.STORAGE_PREVIOUS_CKPT);
        }

        public StorageState analyzeStorage(HdfsServerConstants.StartupOption startOpt, Storage storage) throws IOException {
            assert (this.root != null) : "root is null";
            String rootPath = this.root.getCanonicalPath();
            try {
                if (!this.root.exists()) {
                    if (startOpt != HdfsServerConstants.StartupOption.FORMAT) {
                        LOG.warn((Object)("Storage directory " + rootPath + " does not exist"));
                        return StorageState.NON_EXISTENT;
                    }
                    LOG.info((Object)(rootPath + " does not exist. Creating ..."));
                    if (!this.root.mkdirs()) {
                        throw new IOException("Cannot create directory " + rootPath);
                    }
                }
                if (!this.root.isDirectory()) {
                    LOG.warn((Object)(rootPath + "is not a directory"));
                    return StorageState.NON_EXISTENT;
                }
                if (!FileUtil.canWrite((File)this.root)) {
                    LOG.warn((Object)("Cannot access storage directory " + rootPath));
                    return StorageState.NON_EXISTENT;
                }
            }
            catch (SecurityException ex) {
                LOG.warn((Object)("Cannot access storage directory " + rootPath), (Throwable)ex);
                return StorageState.NON_EXISTENT;
            }
            this.lock();
            if (startOpt == HdfsServerConstants.StartupOption.FORMAT) {
                return StorageState.NOT_FORMATTED;
            }
            if (startOpt != HdfsServerConstants.StartupOption.IMPORT) {
                storage.checkOldLayoutStorage(this);
            }
            File versionFile = this.getVersionFile();
            boolean hasCurrent = versionFile.exists();
            boolean hasPrevious = this.getPreviousDir().exists();
            boolean hasPreviousTmp = this.getPreviousTmp().exists();
            boolean hasRemovedTmp = this.getRemovedTmp().exists();
            boolean hasFinalizedTmp = this.getFinalizedTmp().exists();
            boolean hasCheckpointTmp = this.getLastCheckpointTmp().exists();
            if (!(hasPreviousTmp || hasRemovedTmp || hasFinalizedTmp || hasCheckpointTmp)) {
                if (hasCurrent) {
                    return StorageState.NORMAL;
                }
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "version file in current directory is missing.");
                }
                return StorageState.NOT_FORMATTED;
            }
            if ((hasPreviousTmp ? 1 : 0) + (hasRemovedTmp ? 1 : 0) + (hasFinalizedTmp ? 1 : 0) + (hasCheckpointTmp ? 1 : 0) > 1) {
                throw new InconsistentFSStateException(this.root, "too many temporary directories.");
            }
            if (hasCheckpointTmp) {
                return hasCurrent ? StorageState.COMPLETE_CHECKPOINT : StorageState.RECOVER_CHECKPOINT;
            }
            if (hasFinalizedTmp) {
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "previous and finalized.tmpcannot exist together.");
                }
                return StorageState.COMPLETE_FINALIZE;
            }
            if (hasPreviousTmp) {
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "previous and previous.tmp cannot exist together.");
                }
                if (hasCurrent) {
                    return StorageState.COMPLETE_UPGRADE;
                }
                return StorageState.RECOVER_UPGRADE;
            }
            assert (hasRemovedTmp) : "hasRemovedTmp must be true";
            if (!(hasCurrent ^ hasPrevious)) {
                throw new InconsistentFSStateException(this.root, "one and only one directory current or previous must be present when removed.tmp exists.");
            }
            if (hasCurrent) {
                return StorageState.COMPLETE_ROLLBACK;
            }
            return StorageState.RECOVER_ROLLBACK;
        }

        public void doRecover(StorageState curState) throws IOException {
            File curDir = this.getCurrentDir();
            String rootPath = this.root.getCanonicalPath();
            switch (curState) {
                case COMPLETE_UPGRADE: {
                    LOG.info((Object)("Completing previous upgrade for storage directory " + rootPath));
                    Storage.rename(this.getPreviousTmp(), this.getPreviousDir());
                    return;
                }
                case RECOVER_UPGRADE: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from previous upgrade"));
                    if (curDir.exists()) {
                        Storage.deleteDir(curDir);
                    }
                    Storage.rename(this.getPreviousTmp(), curDir);
                    return;
                }
                case COMPLETE_ROLLBACK: {
                    LOG.info((Object)("Completing previous rollback for storage directory " + rootPath));
                    Storage.deleteDir(this.getRemovedTmp());
                    return;
                }
                case RECOVER_ROLLBACK: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from previous rollback"));
                    Storage.rename(this.getRemovedTmp(), curDir);
                    return;
                }
                case COMPLETE_FINALIZE: {
                    LOG.info((Object)("Completing previous finalize for storage directory " + rootPath));
                    Storage.deleteDir(this.getFinalizedTmp());
                    return;
                }
                case COMPLETE_CHECKPOINT: {
                    LOG.info((Object)("Completing previous checkpoint for storage directory " + rootPath));
                    File prevCkptDir = this.getPreviousCheckpoint();
                    if (prevCkptDir.exists()) {
                        Storage.deleteDir(prevCkptDir);
                    }
                    Storage.rename(this.getLastCheckpointTmp(), prevCkptDir);
                    return;
                }
                case RECOVER_CHECKPOINT: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from failed checkpoint"));
                    if (curDir.exists()) {
                        Storage.deleteDir(curDir);
                    }
                    Storage.rename(this.getLastCheckpointTmp(), curDir);
                    return;
                }
            }
            throw new IOException("Unexpected FS state: " + (Object)((Object)curState));
        }

        @Override
        public boolean hasSomeData() throws IOException {
            if (!this.root.exists()) {
                return false;
            }
            if (!this.root.isDirectory()) {
                return true;
            }
            return FileUtil.listFiles((File)this.root).length != 0;
        }

        public void lock() throws IOException {
            if (!this.useLock) {
                LOG.info((Object)"Locking is disabled");
                return;
            }
            FileLock newLock = this.tryLock();
            if (newLock == null) {
                String msg = "Cannot lock storage " + this.root + ". The directory is already locked";
                LOG.info((Object)msg);
                throw new IOException(msg);
            }
            this.lock = newLock;
        }

        FileLock tryLock() throws IOException {
            boolean deletionHookAdded = false;
            File lockF = new File(this.root, Storage.STORAGE_FILE_LOCK);
            if (!lockF.exists()) {
                lockF.deleteOnExit();
                deletionHookAdded = true;
            }
            RandomAccessFile file = new RandomAccessFile(lockF, "rws");
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            FileLock res = null;
            try {
                res = file.getChannel().tryLock();
                file.write(jvmName.getBytes(Charsets.UTF_8));
                LOG.info((Object)("Lock on " + lockF + " acquired by nodename " + jvmName));
            }
            catch (OverlappingFileLockException oe) {
                String lockingJvmName = Path.WINDOWS ? "" : " " + file.readLine();
                LOG.error((Object)("It appears that another namenode" + lockingJvmName + " has already locked the storage directory"));
                file.close();
                return null;
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to acquire lock on " + lockF + ". If this storage directory is mounted via NFS, " + "ensure that the appropriate nfs lock services are running."), (Throwable)e);
                file.close();
                throw e;
            }
            if (res != null && !deletionHookAdded) {
                lockF.deleteOnExit();
            }
            return res;
        }

        public void unlock() throws IOException {
            if (this.lock == null) {
                return;
            }
            this.lock.release();
            this.lock.channel().close();
            this.lock = null;
        }

        @Override
        public String toString() {
            return "Storage Directory " + this.root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLockSupported() throws IOException {
            FileLock firstLock = null;
            FileLock secondLock = null;
            try {
                firstLock = this.lock;
                if (firstLock == null && (firstLock = this.tryLock()) == null) {
                    boolean bl = true;
                    return bl;
                }
                secondLock = this.tryLock();
                if (secondLock == null) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (firstLock != null && firstLock != this.lock) {
                    firstLock.release();
                    firstLock.channel().close();
                }
                if (secondLock != null) {
                    secondLock.release();
                    secondLock.channel().close();
                }
            }
            return false;
        }
    }

    private class DirIterator
    implements Iterator<StorageDirectory> {
        StorageDirType dirType;
        int prevIndex;
        int nextIndex;

        DirIterator(StorageDirType dirType) {
            this.dirType = dirType;
            this.nextIndex = 0;
            this.prevIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (Storage.this.storageDirs.isEmpty() || this.nextIndex >= Storage.this.storageDirs.size()) {
                return false;
            }
            if (this.dirType != null) {
                while (this.nextIndex < Storage.this.storageDirs.size() && !Storage.this.getStorageDir(this.nextIndex).getStorageDirType().isOfType(this.dirType)) {
                    ++this.nextIndex;
                }
                if (this.nextIndex >= Storage.this.storageDirs.size()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public StorageDirectory next() {
            StorageDirectory sd = Storage.this.getStorageDir(this.nextIndex);
            this.prevIndex = this.nextIndex++;
            if (this.dirType != null) {
                while (this.nextIndex < Storage.this.storageDirs.size() && !Storage.this.getStorageDir(this.nextIndex).getStorageDirType().isOfType(this.dirType)) {
                    ++this.nextIndex;
                }
            }
            return sd;
        }

        @Override
        public void remove() {
            this.nextIndex = this.prevIndex;
            Storage.this.storageDirs.remove(this.prevIndex);
            this.hasNext();
        }
    }

    @InterfaceAudience.Private
    public static interface StorageDirType {
        public StorageDirType getStorageDirType();

        public boolean isOfType(StorageDirType var1);
    }

    public static enum StorageState {
        NON_EXISTENT,
        NOT_FORMATTED,
        COMPLETE_UPGRADE,
        RECOVER_UPGRADE,
        COMPLETE_FINALIZE,
        COMPLETE_ROLLBACK,
        RECOVER_ROLLBACK,
        COMPLETE_CHECKPOINT,
        RECOVER_CHECKPOINT,
        NORMAL;

    }
}

