/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.LightWeightDelayedSet;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;

@InterfaceAudience.Private
class InvalidateBlocks {
    private boolean useDelayed = false;
    private long delayedTime;
    private final Map<String, LightWeightHashSet<Block>> node2blocks = new TreeMap<String, LightWeightHashSet<Block>>();
    private final Map<String, LightWeightDelayedSet<Block>> node2delayedBlocks = new TreeMap<String, LightWeightDelayedSet<Block>>();
    private long numBlocks = 0L;
    private final DatanodeManager datanodeManager;

    InvalidateBlocks(DatanodeManager datanodeManager) {
        this.datanodeManager = datanodeManager;
    }

    synchronized long numBlocks() {
        return this.numBlocks;
    }

    synchronized boolean isUseDelayed() {
        return this.useDelayed;
    }

    synchronized long getDelayedTime() {
        return this.delayedTime;
    }

    private synchronized Collection<Block> getBlockSet(String storageID, boolean initialIfNotExist, boolean delayed) {
        Collection<Object> set;
        if (delayed) {
            set = (LightWeightHashSet)((Object)this.node2delayedBlocks.get(storageID));
            if (set == null && initialIfNotExist) {
                set = new LightWeightDelayedSet(this.delayedTime);
                this.node2delayedBlocks.put(storageID, (LightWeightDelayedSet)set);
            }
        } else {
            set = this.node2blocks.get(storageID);
            if (set == null && initialIfNotExist) {
                set = new LightWeightHashSet();
                this.node2blocks.put(storageID, (LightWeightHashSet<Block>)set);
            }
        }
        return set;
    }

    synchronized boolean contains(String storageID, Block block) {
        Block blockInSet = null;
        LightWeightHashSet<Block> s = this.node2blocks.get(storageID);
        if (s != null) {
            blockInSet = s.getElement(block);
        }
        if (blockInSet == null && this.useDelayed) {
            LightWeightDelayedSet<Block> ds = this.node2delayedBlocks.get(storageID);
            if (ds == null) {
                return false;
            }
            blockInSet = ds.getElement(block);
        }
        return blockInSet != null && block.getGenerationStamp() == blockInSet.getGenerationStamp();
    }

    synchronized void add(Block block, DatanodeInfo datanode, boolean log) {
        if (this.getBlockSet(datanode.getStorageID(), true, this.useDelayed).add(block)) {
            ++this.numBlocks;
            if (log) {
                NameNode.blockStateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": add " + block + " to " + datanode));
            }
        }
    }

    synchronized void add(Block block, DatanodeInfo datanode, boolean log, boolean noDelay) {
        if (noDelay) {
            if (this.useDelayed) {
                this.remove(datanode.getStorageID(), block, true);
            }
            if (this.getBlockSet(datanode.getStorageID(), true, false).add(block)) {
                ++this.numBlocks;
                if (log) {
                    NameNode.blockStateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": add " + block + " to " + datanode));
                }
            }
        } else {
            this.add(block, datanode, log);
        }
    }

    synchronized void remove(String storageID) {
        if (this.useDelayed) {
            this.remove(storageID, true);
        }
        this.remove(storageID, false);
    }

    private void remove(String storageID, boolean delayed) {
        if (delayed) {
            Collection set = this.node2delayedBlocks.remove(storageID);
            if (set != null) {
                this.numBlocks -= (long)set.size();
            }
        } else {
            Collection set = this.node2blocks.remove(storageID);
            if (set != null) {
                this.numBlocks -= (long)set.size();
            }
        }
    }

    synchronized void remove(String storageID, Block block) {
        if (!this.remove(storageID, block, false) && this.useDelayed) {
            this.remove(storageID, block, true);
        }
    }

    private boolean remove(String storageID, Block block, boolean delayed) {
        boolean removed = false;
        if (delayed) {
            Collection set = this.node2delayedBlocks.get(storageID);
            if (set != null) {
                if (set.remove(block)) {
                    --this.numBlocks;
                    removed = true;
                }
                if (set.isEmpty()) {
                    this.remove(storageID, true);
                }
            }
        } else {
            Collection set = this.node2blocks.get(storageID);
            if (set != null) {
                if (set.remove(block)) {
                    --this.numBlocks;
                    removed = true;
                }
                if (set.isEmpty()) {
                    this.remove(storageID, false);
                }
            }
        }
        return removed;
    }

    synchronized void dump(PrintWriter out) {
        Collection blocks;
        int size = this.getStorageIDs().size();
        out.println("Metasave: Blocks " + this.numBlocks + " waiting deletion from " + size + " datanodes,delayed  status:" + (this.useDelayed ? "on(delayed time:" + this.delayedTime + "ms)" : "off"));
        if (size == 0) {
            return;
        }
        if (this.useDelayed) {
            for (Map.Entry<String, Collection<Block>> entry : this.node2delayedBlocks.entrySet()) {
                blocks = (LightWeightDelayedSet)entry.getValue();
                if (((LightWeightDelayedSet)blocks).size() <= 0) continue;
                out.println(this.datanodeManager.getDatanode(entry.getKey()));
                out.println(blocks);
            }
        }
        for (Map.Entry<String, Collection<Block>> entry : this.node2blocks.entrySet()) {
            blocks = (LightWeightHashSet)entry.getValue();
            if (((LightWeightHashSet)blocks).size() <= 0) continue;
            out.println(this.datanodeManager.getDatanode(entry.getKey()));
            out.println(blocks);
        }
    }

    synchronized List<String> getStorageIDs() {
        HashSet<String> ids = new HashSet<String>(Math.max(this.node2delayedBlocks.size(), this.node2blocks.size()));
        if (this.useDelayed) {
            ids.addAll(this.node2delayedBlocks.keySet());
        }
        ids.addAll(this.node2blocks.keySet());
        return new ArrayList<String>(ids);
    }

    int invalidateWork(String storageId) {
        DatanodeDescriptor dn = this.datanodeManager.getDatanode(storageId);
        if (dn == null) {
            this.remove(storageId);
            return 0;
        }
        List<Block> toInvalidate = this.invalidateWork(storageId, dn);
        if (toInvalidate == null || toInvalidate.isEmpty()) {
            return 0;
        }
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": ask " + dn + " to delete " + toInvalidate + ",size:" + toInvalidate.size() + ",remain:" + this.numBlocks));
        }
        return toInvalidate.size();
    }

    private synchronized List<Block> invalidateWork(String storageId, DatanodeDescriptor dn) {
        List<Block> toInvalidateDelayed;
        List<Block> toInvalidate = null;
        int limit = this.datanodeManager.blockInvalidateLimit;
        toInvalidate = this.poll2InvalidateNoDelayed(storageId, limit);
        if (toInvalidate == null) {
            toInvalidate = new ArrayList<Block>();
        }
        int polledSize = toInvalidate.size();
        int left = limit - polledSize;
        if (this.useDelayed && left > 0 && (toInvalidateDelayed = this.poll2InvalidateInDelayed(storageId, left)) != null) {
            toInvalidate.addAll(toInvalidateDelayed);
        }
        dn.addBlocksToBeInvalidated(toInvalidate);
        this.numBlocks -= (long)toInvalidate.size();
        return toInvalidate;
    }

    private List<Block> poll2InvalidateInDelayed(String storageId, int limit) {
        if (this.node2delayedBlocks.isEmpty()) {
            return null;
        }
        List<Block> toInvalidate = null;
        LightWeightDelayedSet<Block> delayedSet = this.node2delayedBlocks.get(storageId);
        if (delayedSet != null) {
            toInvalidate = delayedSet.pollN(limit);
            if (delayedSet.isEmpty()) {
                this.remove(storageId, true);
            }
        }
        return toInvalidate;
    }

    private List<Block> poll2InvalidateNoDelayed(String storageId, int limit) {
        if (this.node2blocks.isEmpty()) {
            return null;
        }
        List<Block> toInvalidate = null;
        LightWeightHashSet<Block> set = this.node2blocks.get(storageId);
        if (set != null) {
            toInvalidate = set.pollN(limit);
            if (set.isEmpty()) {
                this.remove(storageId, false);
            }
        }
        return toInvalidate;
    }

    synchronized void clear() {
        this.node2blocks.clear();
        this.node2delayedBlocks.clear();
        this.numBlocks = 0L;
    }

    synchronized long rollback(String ... storageIDs) {
        long lastNumBlocks = this.numBlocks;
        for (String storageId : storageIDs) {
            this.remove(storageId);
        }
        long rs = lastNumBlocks - this.numBlocks;
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": rollback invalid blocks,size:" + rs + ",storage ids:" + Arrays.toString(storageIDs)));
        }
        return rs;
    }

    synchronized long rollback() {
        long lastNumBlocks = this.numBlocks;
        this.clear();
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": rollback all invalid blocks,size:" + lastNumBlocks));
        }
        return lastNumBlocks;
    }

    synchronized void setDelayedInvalid(long delayTime) {
        boolean lastDelayed = this.useDelayed;
        long lastDelayTime = this.delayedTime;
        if (delayTime > 0L) {
            this.useDelayed = true;
            this.delayedTime = delayTime;
            this.adjustDelayInvalid(this.delayedTime - lastDelayTime, new String[0]);
        } else {
            this.useDelayed = false;
            this.delayedTime = 0L;
            if (lastDelayed) {
                this.drainDelayIfPesent();
            }
        }
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": delayed invalid status " + (this.useDelayed ? "on(delayed time:" + this.delayedTime + "ms,last delayed time:" + lastDelayTime + "ms)" : "off")));
        }
    }

    public synchronized void advanceNowInvalidIfHasDelay() {
        this.adjustDelayInvalid(-this.delayedTime, new String[0]);
    }

    public synchronized void advanceNowInvalidIfHasDelay(String ... storageIDs) {
        this.adjustDelayInvalid(-this.delayedTime, storageIDs);
    }

    private void adjustDelayInvalid(long offsetTime, String ... storageIDs) {
        if (!this.useDelayed || offsetTime == 0L || storageIDs == null) {
            return;
        }
        boolean isAll = false;
        if (storageIDs == null || storageIDs.length == 0 || "*".equals(storageIDs[0])) {
            isAll = true;
        }
        HashSet<String> set = isAll ? new HashSet<String>(this.node2delayedBlocks.keySet()) : Sets.newHashSet((Object[])storageIDs);
        for (String storageId : set) {
            this.adjustDelayInvalid(storageId, this.node2delayedBlocks.get(storageId), offsetTime);
        }
    }

    private void adjustDelayInvalid(String storageId, LightWeightDelayedSet<Block> ds, long offsetTime) {
        if (ds != null) {
            ds.adjustTime(offsetTime);
        }
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.getClass().getSimpleName() + ": storage:" + storageId + " adjust delayed invalid offset time: " + offsetTime + ",size:" + (ds != null ? ds.size() : 0)));
        }
    }

    private void drainDelayIfPesent(String storageId) {
        if (this.useDelayed) {
            return;
        }
        LightWeightDelayedSet<Block> ds = this.node2delayedBlocks.remove(storageId);
        if (!ds.isEmpty()) {
            LightWeightHashSet<Block> s = this.node2blocks.get(storageId);
            if (s == null) {
                s = new LightWeightHashSet();
                this.node2blocks.put(storageId, s);
            }
            ds.drainTo(s);
        }
    }

    private void drainDelayIfPesent() {
        if (this.useDelayed) {
            return;
        }
        HashSet<String> keySet = new HashSet<String>(this.node2delayedBlocks.keySet());
        for (String storageId : keySet) {
            this.drainDelayIfPesent(storageId);
        }
    }
}

