/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.openapi.config;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public Response<String> handleConstraintViolationException(HttpServletRequest request, ConstraintViolationException e) {
        Set violations = e.getConstraintViolations();
        StringBuilder stringBuilder = new StringBuilder(64);
        for (ConstraintViolation violation : violations) {
            stringBuilder.append(violation.getMessage()).append(".");
        }
        UserDetail userDetail = LoginUserUtil.getLoginUserDetail();
        log.error("Failed to handle request on path: " + request.getRequestURI() + (userDetail != null ? ", user: " + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)stringBuilder.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Response<String> handleMethodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        UserDetail userDetail = LoginUserUtil.getLoginUserDetail();
        log.error("Failed to handle request on path: " + request.getRequestURI() + (userDetail != null ? ", user: " + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public Response<String> handleBusinessExceptionHandler(HttpServletRequest request, BusinessException e) {
        UserDetail userDetail = LoginUserUtil.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user: " + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Response<String> handle(HttpServletRequest request, Exception e) {
        UserDetail userDetail = LoginUserUtil.getLoginUserDetail();
        log.error("Failed to handle request on path: " + request.getRequestURI() + (userDetail != null ? ", user: " + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }
}

