/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.openapi.auth;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.openapi.auth.MockAuthenticationToken;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    private boolean supportMockUsername;

    public AuthenticationFilter(boolean supportMockUsername) {
        if (supportMockUsername) {
            log.warn(" Ensure that you are not using test mode in production environment.");
        }
        this.supportMockUsername = supportMockUsername;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        MockAuthenticationToken mockAuthenticationToken = new MockAuthenticationToken(httpServletRequest);
        MockAuthenticationToken token = null;
        if (this.supportMockUsername && !mockAuthenticationToken.isEmpty()) {
            token = mockAuthenticationToken;
        }
        Subject subject = SecurityUtils.getSubject();
        if (token != null) {
            SecurityUtils.getSubject().login((AuthenticationToken)token);
            if (log.isDebugEnabled()) {
                log.debug("Login user: " + SecurityUtils.getSubject().getPrincipal() + ", token " + token.getClass().getSimpleName());
            }
        }
        if (!subject.isAuthenticated()) {
            log.error("Access denied for anonymous user:{}  path:{} ", subject.getPrincipal(), (Object)httpServletRequest.getServletPath());
            ((HttpServletResponse)servletResponse).sendError(403);
            return;
        }
        LoginUserUtil.setUserLoginInfo((UserDetail)new UserDetail().setUserName((String)subject.getPrincipal()));
        filterChain.doFilter(servletRequest, servletResponse);
        LoginUserUtil.removeUserLoginInfo();
    }

    public void destroy() {
    }
}

