/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort;

import org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.sort.configuration.Configuration;
import org.apache.inlong.sort.configuration.Constants;
import org.apache.inlong.sort.protocol.DataFlowInfo;
import org.apache.inlong.sort.protocol.DataFlowStorageInfo;
import org.apache.inlong.sort.util.ZooKeeperUtils;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkTools {
    private static final Logger LOG = LoggerFactory.getLogger(ZkTools.class);

    public static void addDataFlowToCluster(String cluster, long dataFlowId, String zkQuorum, String zkRoot) throws Exception {
        Configuration config = new Configuration();
        config.setString(Constants.ZOOKEEPER_QUORUM, zkQuorum);
        config.setString(Constants.ZOOKEEPER_ROOT, zkRoot);
        String watchingPath = ZkTools.getNodePathOfDataFlowStorageInfoInCluster(cluster, dataFlowId);
        try (CuratorFramework zkClient = ZooKeeperUtils.startCuratorFramework(config);){
            if (zkClient.checkExists().forPath(watchingPath) == null) {
                ZooKeeperUtils.createRecursive(zkClient, watchingPath, null, CreateMode.PERSISTENT);
            }
        }
        LOG.info("Add dataFlow with id {} to cluster {} successfully", (Object)dataFlowId, (Object)cluster);
    }

    public static void removeDataFlowFromCluster(String cluster, long dataFlowId, String zkQuorum, String zkRoot) throws Exception {
        Configuration config = new Configuration();
        config.setString(Constants.ZOOKEEPER_QUORUM, zkQuorum);
        config.setString(Constants.ZOOKEEPER_ROOT, zkRoot);
        String watchingPath = ZkTools.getNodePathOfDataFlowStorageInfoInCluster(cluster, dataFlowId);
        try (CuratorFramework zkClient = ZooKeeperUtils.startCuratorFramework(config);){
            if (zkClient.checkExists().forPath(watchingPath) != null) {
                zkClient.delete().forPath(watchingPath);
            }
        }
        LOG.info("Remove dataFlow with id {} to cluster {} successfully", (Object)dataFlowId, (Object)cluster);
    }

    public static void updateDataFlowInfo(DataFlowInfo dataFlowInfo, String cluster, long dataFlowId, String zkQuorum, String zkRoot) throws Exception {
        Configuration config = new Configuration();
        config.setString(Constants.ZOOKEEPER_QUORUM, zkQuorum);
        config.setString(Constants.ZOOKEEPER_ROOT, zkRoot);
        ObjectMapper objectMapper = new ObjectMapper();
        String dataFlowInfoPath = ZkTools.getNodePathOfDataFlowInfo(dataFlowId);
        String dataFlowStorageInfoPath = ZkTools.getNodePathOfDataFlowStorageInfoInCluster(cluster, dataFlowId);
        try (CuratorFramework zkClient = ZooKeeperUtils.startCuratorFramework(config);){
            byte[] dataFlowInfoData = objectMapper.writeValueAsBytes(dataFlowInfo);
            if (zkClient.checkExists().forPath(dataFlowInfoPath) == null) {
                ZooKeeperUtils.createRecursive(zkClient, dataFlowInfoPath, dataFlowInfoData, CreateMode.PERSISTENT);
            } else {
                zkClient.setData().forPath(dataFlowInfoPath, dataFlowInfoData);
            }
            DataFlowStorageInfo dataFlowStorageInfo = new DataFlowStorageInfo(DataFlowStorageInfo.StorageType.ZK, dataFlowInfoPath);
            byte[] dataFlowStorageInfoData = objectMapper.writeValueAsBytes(dataFlowStorageInfo);
            if (zkClient.checkExists().forPath(dataFlowStorageInfoPath) == null) {
                ZooKeeperUtils.createRecursive(zkClient, dataFlowStorageInfoPath, dataFlowStorageInfoData, CreateMode.PERSISTENT);
            } else {
                zkClient.setData().forPath(dataFlowStorageInfoPath, dataFlowStorageInfoData);
            }
        }
        LOG.info("Update DataFlowInfo with id {} on zk successfully", (Object)dataFlowId);
    }

    public static String getNodePathOfDataFlowStorageInfoInCluster(String cluster, long dataFlowId) {
        return "/clusters/" + cluster + "/dataflows/" + dataFlowId;
    }

    public static String getNodePathOfDataFlowInfo(long dataFlowId) {
        return "/dataflows/" + dataFlowId;
    }
}

