/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.InlongStreamApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.sink.ParseFieldRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamPageRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;

public class InlongStreamClient {
    private final InlongStreamApi inlongStreamApi;

    public InlongStreamClient(ClientConfiguration configuration) {
        this.inlongStreamApi = (InlongStreamApi)ClientUtils.createRetrofit(configuration).create(InlongStreamApi.class);
    }

    public Integer createStreamInfo(InlongStreamInfo streamInfo) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.inlongStreamApi.createStream(streamInfo));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public Boolean isStreamExists(InlongStreamInfo streamInfo) {
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongStreamApi.isStreamExists(groupId, streamId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Pair<Boolean, String> updateStreamInfo(InlongStreamInfo streamInfo) {
        Response<Boolean> resp = ClientUtils.executeHttpCall(this.inlongStreamApi.updateStream(streamInfo));
        if (resp.getData() != null) {
            return Pair.of((Object)resp.getData(), (Object)resp.getErrMsg());
        }
        return Pair.of((Object)false, (Object)resp.getErrMsg());
    }

    public InlongStreamInfo getStreamInfo(String groupId, String streamId) {
        Response<InlongStreamInfo> response = ClientUtils.executeHttpCall(this.inlongStreamApi.getStream(groupId, streamId));
        if (response.isSuccess()) {
            return (InlongStreamInfo)response.getData();
        }
        if (response.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(response.getErrMsg());
    }

    public InlongStreamBriefInfo getStreamBriefInfo(String groupId, String streamId) {
        Response<InlongStreamBriefInfo> response = ClientUtils.executeHttpCall(this.inlongStreamApi.getStreamBriefInfo(groupId, streamId));
        if (response.isSuccess()) {
            return (InlongStreamBriefInfo)response.getData();
        }
        if (response.getErrMsg().contains("not exist")) {
            return null;
        }
        throw new RuntimeException(response.getErrMsg());
    }

    public InlongStreamInfo getStreamIfExists(InlongStreamInfo streamInfo) {
        if (this.isStreamExists(streamInfo).booleanValue()) {
            return this.getStreamInfo(streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId());
        }
        return null;
    }

    public PageResult<InlongStreamBriefInfo> listByCondition(InlongStreamPageRequest request) {
        Response<PageResult<InlongStreamBriefInfo>> response = ClientUtils.executeHttpCall(this.inlongStreamApi.listByCondition(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public PageResult<InlongStreamInfo> listAllByCondition(InlongStreamPageRequest request) {
        Response<PageResult<InlongStreamInfo>> pageResultResponse = ClientUtils.executeHttpCall(this.inlongStreamApi.listStream(request));
        ClientUtils.assertRespSuccess(pageResultResponse);
        return (PageResult)pageResultResponse.getData();
    }

    public List<InlongStreamInfo> listStreamInfo(String inlongGroupId) {
        InlongStreamPageRequest pageRequest = new InlongStreamPageRequest();
        pageRequest.setInlongGroupId(inlongGroupId);
        Response<PageResult<InlongStreamInfo>> response = ClientUtils.executeHttpCall(this.inlongStreamApi.listStream(pageRequest));
        ClientUtils.assertRespSuccess(response);
        return ((PageResult)response.getData()).getList();
    }

    public boolean startProcess(String groupId, String streamId, boolean sync) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongStreamApi.startProcess(groupId, streamId, sync));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean suspendProcess(String groupId, String streamId, boolean sync) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongStreamApi.suspendProcess(groupId, streamId, sync));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean restartProcess(String groupId, String streamId, boolean sync) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongStreamApi.restartProcess(groupId, streamId, sync));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean deleteProcess(String groupId, String streamId, boolean sync) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongStreamApi.deleteProcess(groupId, streamId, sync));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean delete(String groupId, String streamId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongStreamApi.delete(groupId, streamId));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public List<StreamField> parseFields(ParseFieldRequest parseFieldRequest) {
        Response<List<StreamField>> response = ClientUtils.executeHttpCall(this.inlongStreamApi.parseFields(parseFieldRequest));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public List<StreamField> parseFields(String method, String statement) {
        Preconditions.expectTrue(("json".equals(method) || "sql".equals(method) ? 1 : 0) != 0, (String)("Unsupported parse field method: '" + method + "'"));
        Preconditions.expectNotBlank((String)statement, (String)"The statement must not empty");
        ParseFieldRequest request = ParseFieldRequest.builder().method(method).statement(statement).build();
        return this.parseFields(request);
    }

    public List<BriefMQMessage> queryMessage(String groupId, String streamId, Integer messageCount) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)streamId, (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<List<BriefMQMessage>> response = ClientUtils.executeHttpCall(this.inlongStreamApi.listMessages(groupId, streamId, messageCount));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }
}

