/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import java.util.List;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.InlongClusterApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.cluster.BindTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagResponse;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.common.UpdateResult;

public class InlongClusterClient {
    private final InlongClusterApi inlongClusterApi;

    public InlongClusterClient(ClientConfiguration configuration) {
        this.inlongClusterApi = (InlongClusterApi)ClientUtils.createRetrofit(configuration).create(InlongClusterApi.class);
    }

    public Integer saveTag(ClusterTagRequest request) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.inlongClusterApi.saveTag(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public ClusterTagResponse getTag(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id should not be empty");
        Response<ClusterTagResponse> response = ClientUtils.executeHttpCall(this.inlongClusterApi.getTag(id));
        ClientUtils.assertRespSuccess(response);
        return (ClusterTagResponse)response.getData();
    }

    public PageResult<ClusterTagResponse> listTag(ClusterTagPageRequest request) {
        Response<PageResult<ClusterTagResponse>> response = ClientUtils.executeHttpCall(this.inlongClusterApi.listTag(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public Boolean updateTag(ClusterTagRequest request) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.updateTag(request));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean deleteTag(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id should not be empty");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.deleteTag(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Integer saveCluster(ClusterRequest request) {
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster name should not be empty");
        Preconditions.expectNotBlank((String)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster type should not be empty");
        Preconditions.expectNotBlank((String)request.getClusterTags(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster tags should not be empty");
        Response<Integer> clusterIndexResponse = ClientUtils.executeHttpCall(this.inlongClusterApi.save(request));
        ClientUtils.assertRespSuccess(clusterIndexResponse);
        return (Integer)clusterIndexResponse.getData();
    }

    public ClusterInfo get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id should not be empty");
        Response<ClusterInfo> clusterInfoResponse = ClientUtils.executeHttpCall(this.inlongClusterApi.get(id));
        ClientUtils.assertRespSuccess(clusterInfoResponse);
        return (ClusterInfo)clusterInfoResponse.getData();
    }

    public PageResult<ClusterInfo> list(ClusterPageRequest request) {
        Response<PageResult<ClusterInfo>> response = ClientUtils.executeHttpCall(this.inlongClusterApi.list(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public PageResult<ClusterInfo> listByTenantRole(ClusterPageRequest request) {
        Response<PageResult<ClusterInfo>> response = ClientUtils.executeHttpCall(this.inlongClusterApi.listByTenantRole(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public Boolean update(ClusterRequest request) {
        Preconditions.expectNotNull((Object)request.getId(), (String)"inlong cluster id cannot be empty");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.update(request));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public UpdateResult updateByKey(ClusterRequest request) {
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster name should not be null");
        Preconditions.expectNotBlank((String)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster type should not be null");
        Response<UpdateResult> response = ClientUtils.executeHttpCall(this.inlongClusterApi.updateByKey(request));
        ClientUtils.assertRespSuccess(response);
        return (UpdateResult)response.getData();
    }

    public Boolean bindTag(BindTagRequest request) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.bindTag(request));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id should not be empty");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.delete(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean deleteByKey(String name, String type) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster name should not be empty");
        Preconditions.expectNotBlank((String)type, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster type should not be empty");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.deleteByKey(name, type));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Integer saveNode(ClusterNodeRequest request) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.inlongClusterApi.saveNode(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public ClusterNodeResponse getNode(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id should not be empty");
        Response<ClusterNodeResponse> response = ClientUtils.executeHttpCall(this.inlongClusterApi.getNode(id));
        ClientUtils.assertRespSuccess(response);
        return (ClusterNodeResponse)response.getData();
    }

    public PageResult<ClusterNodeResponse> listNode(ClusterPageRequest request) {
        Response<PageResult<ClusterNodeResponse>> response = ClientUtils.executeHttpCall(this.inlongClusterApi.listNode(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public List<ClusterNodeResponse> listNode(String inlongGroupId, String clusterType, String protocolType) {
        Response<List<ClusterNodeResponse>> response = ClientUtils.executeHttpCall(this.inlongClusterApi.listNodeByGroupId(inlongGroupId, clusterType, protocolType));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public Boolean updateNode(ClusterNodeRequest request) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.updateNode(request));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean deleteNode(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id should not be empty");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.inlongClusterApi.deleteNode(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

