/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.inner.client.AuditClient;
import org.apache.inlong.manager.client.api.inner.client.DataNodeClient;
import org.apache.inlong.manager.client.api.inner.client.HeartbeatClient;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.InlongConsumeClient;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.api.inner.client.InlongStreamClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantRoleClient;
import org.apache.inlong.manager.client.api.inner.client.NoAuthClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSinkClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSourceClient;
import org.apache.inlong.manager.client.api.inner.client.StreamTransformClient;
import org.apache.inlong.manager.client.api.inner.client.UserClient;
import org.apache.inlong.manager.client.api.inner.client.WorkflowApproverClient;
import org.apache.inlong.manager.client.api.inner.client.WorkflowClient;
import org.apache.inlong.manager.client.api.inner.client.WorkflowEventClient;

public class ClientFactory {
    private final InlongGroupClient groupClient;
    private final InlongStreamClient streamClient;
    private final StreamSinkClient sinkClient;
    private final StreamSourceClient sourceClient;
    private final InlongClusterClient clusterClient;
    private final StreamTransformClient transformClient;
    private final WorkflowClient workflowClient;
    private final DataNodeClient dataNodeClient;
    private final UserClient userClient;
    private final NoAuthClient noAuthClient;
    private final HeartbeatClient heartbeatClient;
    private final WorkflowApproverClient workflowApproverClient;
    private final WorkflowEventClient workflowEventClient;
    private final InlongConsumeClient consumeClient;
    private final AuditClient auditClient;
    private final InlongTenantClient inlongTenantClient;
    private final InlongTenantRoleClient inlongTenantRoleClient;

    public ClientFactory(ClientConfiguration configuration) {
        this.groupClient = new InlongGroupClient(configuration);
        this.streamClient = new InlongStreamClient(configuration);
        this.sourceClient = new StreamSourceClient(configuration);
        this.sinkClient = new StreamSinkClient(configuration);
        this.clusterClient = new InlongClusterClient(configuration);
        this.transformClient = new StreamTransformClient(configuration);
        this.workflowClient = new WorkflowClient(configuration);
        this.dataNodeClient = new DataNodeClient(configuration);
        this.userClient = new UserClient(configuration);
        this.noAuthClient = new NoAuthClient(configuration);
        this.heartbeatClient = new HeartbeatClient(configuration);
        this.workflowApproverClient = new WorkflowApproverClient(configuration);
        this.workflowEventClient = new WorkflowEventClient(configuration);
        this.consumeClient = new InlongConsumeClient(configuration);
        this.auditClient = new AuditClient(configuration);
        this.inlongTenantClient = new InlongTenantClient(configuration);
        this.inlongTenantRoleClient = new InlongTenantRoleClient(configuration);
    }

    public InlongGroupClient getGroupClient() {
        return this.groupClient;
    }

    public InlongStreamClient getStreamClient() {
        return this.streamClient;
    }

    public StreamSinkClient getSinkClient() {
        return this.sinkClient;
    }

    public StreamSourceClient getSourceClient() {
        return this.sourceClient;
    }

    public InlongClusterClient getClusterClient() {
        return this.clusterClient;
    }

    public StreamTransformClient getTransformClient() {
        return this.transformClient;
    }

    public WorkflowClient getWorkflowClient() {
        return this.workflowClient;
    }

    public DataNodeClient getDataNodeClient() {
        return this.dataNodeClient;
    }

    public UserClient getUserClient() {
        return this.userClient;
    }

    public NoAuthClient getNoAuthClient() {
        return this.noAuthClient;
    }

    public HeartbeatClient getHeartbeatClient() {
        return this.heartbeatClient;
    }

    public WorkflowApproverClient getWorkflowApproverClient() {
        return this.workflowApproverClient;
    }

    public WorkflowEventClient getWorkflowEventClient() {
        return this.workflowEventClient;
    }

    public InlongConsumeClient getConsumeClient() {
        return this.consumeClient;
    }

    public AuditClient getAuditClient() {
        return this.auditClient;
    }

    public InlongTenantClient getInlongTenantClient() {
        return this.inlongTenantClient;
    }

    public InlongTenantRoleClient getInlongTenantRoleClient() {
        return this.inlongTenantRoleClient;
    }
}

