/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import java.util.List;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.AuditApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.audit.AuditRequest;
import org.apache.inlong.manager.pojo.audit.AuditVO;
import org.apache.inlong.manager.pojo.common.Response;

public class AuditClient {
    private final AuditApi auditApi;

    public AuditClient(ClientConfiguration configuration) {
        this.auditApi = (AuditApi)ClientUtils.createRetrofit(configuration).create(AuditApi.class);
    }

    public List<AuditVO> list(AuditRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong group id cannot be empty");
        Preconditions.expectNotBlank((String)request.getInlongStreamId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong stream id cannot be empty");
        Response<List<AuditVO>> response = ClientUtils.executeHttpCall(this.auditApi.list(request));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public Boolean refreshCache(AuditRequest request) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.auditApi.refreshCache());
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

