/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.Workflow;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.WorkflowClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.pojo.workflow.TaskRequest;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowOperationRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;

public class WorkflowImpl
implements Workflow {
    private final WorkflowClient workflowClient;

    public WorkflowImpl(ClientConfiguration configuration) {
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.workflowClient = clientFactory.getWorkflowClient();
    }

    @Override
    public WorkflowResult start(WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)request.getName(), (String)"process name cannot be null");
        Preconditions.expectNotNull((Object)request.getForm(), (String)"form cannot be null");
        return this.workflowClient.start(request);
    }

    @Override
    public WorkflowResult cancel(Integer processId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)processId, (String)"process id cannot be null");
        return this.workflowClient.cancel(processId, request);
    }

    @Override
    public WorkflowResult continueProcess(Integer processId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)processId, (String)"process id cannot be null");
        return this.workflowClient.continueProcess(processId, request);
    }

    @Override
    public WorkflowResult reject(Integer taskId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)taskId, (String)"task id cannot be null");
        return this.workflowClient.reject(taskId, request);
    }

    @Override
    public WorkflowResult complete(Integer taskId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)taskId, (String)"task id cannot be null");
        return this.workflowClient.complete(taskId, request);
    }

    @Override
    public ProcessDetailResponse detail(Integer processId, Integer taskId) {
        Preconditions.expectNotNull((Object)processId, (String)"process id cannot be null");
        return this.workflowClient.detail(processId, taskId);
    }

    @Override
    public PageResult<ProcessResponse> listProcess(ProcessRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"process request cannot be null");
        return this.workflowClient.listProcess(request);
    }

    @Override
    public PageResult<TaskResponse> listTask(TaskRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"task request cannot be null");
        return this.workflowClient.listTask(request);
    }
}

