/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault.persistence;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.NotNull;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;

class RocksIteratorAdapter
implements Cursor<VaultEntry> {
    private final RocksIterator it;
    private final Slice lowerBound;
    private final Slice upperBound;

    RocksIteratorAdapter(RocksIterator it, Slice lowerBound, Slice upperBound) {
        this.it = it;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public Iterator<VaultEntry> iterator() {
        return this;
    }

    public void close() throws Exception {
        IgniteUtils.closeAll(List.of(this.lowerBound, this.upperBound, this.it));
    }

    public boolean hasNext() {
        boolean isValid = this.it.isValid();
        if (!isValid) {
            try {
                this.it.status();
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException((Throwable)e);
            }
        }
        return isValid;
    }

    public VaultEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        VaultEntry result = new VaultEntry(new ByteArray(this.it.key()), this.it.value());
        this.it.next();
        return result;
    }
}

