/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault.persistence;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultService;
import org.apache.ignite.internal.vault.persistence.RocksIteratorAdapter;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class PersistentVaultService
implements VaultService {
    private final ExecutorService threadPool = Executors.newFixedThreadPool(2);
    private final Options options = new Options();
    private volatile RocksDB db;
    private final Path path;

    public PersistentVaultService(Path path) {
        this.path = path;
    }

    public void start() {
        this.options.setCreateIfMissing(true).setCompressionType(CompressionType.LZ4_COMPRESSION).setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION).setLevelCompactionDynamicLevelBytes(true).setBytesPerSync(0x100000L).setCompactionPriority(CompactionPriority.MinOverlappingRatio).setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setBlockSize(16384L).setCacheIndexAndFilterBlocks(true).setPinL0FilterAndIndexBlocksInCache(true).setFormatVersion(5).setFilterPolicy((Filter)new BloomFilter(10.0, false)).setOptimizeFiltersForMemory(true));
        try {
            this.db = RocksDB.open((Options)this.options, (String)this.path.toString());
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException((Throwable)e);
        }
    }

    public void stop() {
        try {
            this.close();
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException((Throwable)e);
        }
    }

    @Override
    public void close() throws RocksDBException {
        this.db.syncWal();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.options.close();
        this.db.close();
    }

    @Override
    @NotNull
    public CompletableFuture<VaultEntry> get(@NotNull ByteArray key) {
        return this.supplyAsync(() -> this.db.get(key.bytes())).thenApply(v -> new VaultEntry(key, (byte[])v));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> put(@NotNull ByteArray key, byte @Nullable [] val) {
        return val == null ? this.remove(key) : this.runAsync(() -> this.db.put(key.bytes(), val));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> remove(@NotNull ByteArray key) {
        return this.runAsync(() -> this.db.delete(key.bytes()));
    }

    @Override
    @NotNull
    public Cursor<VaultEntry> range(@NotNull ByteArray fromKey, @NotNull ByteArray toKey) {
        try (ReadOptions readOpts = new ReadOptions();){
            Slice lowerBound = new Slice(fromKey.bytes());
            Slice upperBound = new Slice(toKey.bytes());
            readOpts.setIterateLowerBound((AbstractSlice)lowerBound).setIterateUpperBound((AbstractSlice)upperBound);
            RocksIterator it = this.db.newIterator(readOpts);
            it.seekToFirst();
            RocksIteratorAdapter rocksIteratorAdapter = new RocksIteratorAdapter(it, lowerBound, upperBound);
            return rocksIteratorAdapter;
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> putAll(@NotNull Map<ByteArray, byte[]> vals) {
        return this.runAsync(() -> {
            try (WriteBatch writeBatch = new WriteBatch();
                 WriteOptions writeOpts = new WriteOptions();){
                for (Map.Entry entry : vals.entrySet()) {
                    if (entry.getValue() == null) {
                        writeBatch.delete(((ByteArray)entry.getKey()).bytes());
                        continue;
                    }
                    writeBatch.put(((ByteArray)entry.getKey()).bytes(), (byte[])entry.getValue());
                }
                this.db.write(writeOpts, writeBatch);
            }
        });
    }

    private <T> CompletableFuture<T> supplyAsync(RocksSupplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return supplier.supply();
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException((Throwable)e);
            }
        }, this.threadPool);
    }

    private CompletableFuture<Void> runAsync(RocksRunnable runnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable.run();
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException((Throwable)e);
            }
        }, this.threadPool);
    }

    static {
        RocksDB.loadLibrary();
    }

    @FunctionalInterface
    private static interface RocksRunnable {
        public void run() throws RocksDBException;
    }

    @FunctionalInterface
    private static interface RocksSupplier<T> {
        public T supply() throws RocksDBException;
    }
}

