/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault.inmemory;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultService;
import org.apache.ignite.lang.ByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryVaultService
implements VaultService {
    private final NavigableMap<ByteArray, byte[]> storage = new TreeMap<ByteArray, byte[]>();
    private final Object mux = new Object();

    public void start() {
    }

    public void stop() {
        this.close();
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<VaultEntry> get(@NotNull ByteArray key) {
        Object object = this.mux;
        synchronized (object) {
            return CompletableFuture.completedFuture(new VaultEntry(key, (byte[])this.storage.get(key)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> put(@NotNull ByteArray key, byte @Nullable [] val) {
        Object object = this.mux;
        synchronized (object) {
            this.storage.put(key, val);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> remove(@NotNull ByteArray key) {
        Object object = this.mux;
        synchronized (object) {
            this.storage.remove(key);
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Cursor<VaultEntry> range(@NotNull ByteArray fromKey, @NotNull ByteArray toKey) {
        Iterator it;
        if (fromKey.compareTo(toKey) >= 0) {
            it = Collections.emptyIterator();
        } else {
            Object object = this.mux;
            synchronized (object) {
                it = this.storage.subMap(fromKey, toKey).entrySet().stream().map(e -> new VaultEntry(new ByteArray((ByteArray)e.getKey()), (byte[])e.getValue())).collect(Collectors.toList()).iterator();
            }
        }
        return new Cursor<VaultEntry>(){

            public void close() {
            }

            @NotNull
            public Iterator<VaultEntry> iterator() {
                return this;
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public VaultEntry next() {
                return (VaultEntry)it.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> putAll(@NotNull Map<ByteArray, byte[]> vals) {
        Object object = this.mux;
        synchronized (object) {
            for (Map.Entry<ByteArray, byte[]> entry : vals.entrySet()) {
                if (entry.getValue() == null) {
                    this.storage.remove(entry.getKey());
                    continue;
                }
                this.storage.put(entry.getKey(), entry.getValue());
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

