/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultService;
import org.apache.ignite.lang.ByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultManager
implements IgniteComponent {
    private static final ByteArray NODE_NAME = new ByteArray("node_name");
    private final VaultService vaultSvc;

    public VaultManager(VaultService vaultSvc) {
        this.vaultSvc = vaultSvc;
    }

    public void start() {
        this.vaultSvc.start();
    }

    public void stop() throws Exception {
        this.vaultSvc.close();
    }

    public CompletableFuture<VaultEntry> get(@NotNull ByteArray key) {
        return this.vaultSvc.get(key);
    }

    public CompletableFuture<Void> put(@NotNull ByteArray key, byte @Nullable [] val) {
        return this.vaultSvc.put(key, val);
    }

    public CompletableFuture<Void> remove(@NotNull ByteArray key) {
        return this.vaultSvc.remove(key);
    }

    public Cursor<VaultEntry> range(@NotNull ByteArray fromKey, @NotNull ByteArray toKey) {
        return this.vaultSvc.range(fromKey, toKey);
    }

    public CompletableFuture<Void> putAll(@NotNull Map<ByteArray, byte[]> vals) {
        return this.vaultSvc.putAll(vals);
    }

    public CompletableFuture<Void> putName(String name) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        return this.put(NODE_NAME, name.getBytes(StandardCharsets.UTF_8));
    }

    public CompletableFuture<String> name() {
        return ((CompletableFuture)this.vaultSvc.get(NODE_NAME).thenApply(VaultEntry::value)).thenApply(name -> name == null ? null : new String((byte[])name, StandardCharsets.UTF_8));
    }
}

