/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.vault.common.Entry;
import org.apache.ignite.internal.vault.common.VaultWatch;
import org.apache.ignite.internal.vault.common.WatcherImpl;
import org.apache.ignite.internal.vault.service.VaultService;
import org.apache.ignite.lang.ByteArray;
import org.jetbrains.annotations.NotNull;

public class VaultServiceImpl
implements VaultService {
    private final NavigableMap<ByteArray, byte[]> storage;
    private final Object mux = new Object();
    private final WatcherImpl watcher = new WatcherImpl();

    public VaultServiceImpl() {
        this.storage = new TreeMap<ByteArray, byte[]>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Entry> get(@NotNull ByteArray key) {
        Object object = this.mux;
        synchronized (object) {
            return CompletableFuture.completedFuture(new Entry(key, (byte[])this.storage.get(key)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> put(@NotNull ByteArray key, @NotNull byte[] val) {
        Object object = this.mux;
        synchronized (object) {
            this.storage.put(key, val);
            this.watcher.notify(new Entry(key, val));
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> remove(@NotNull ByteArray key) {
        Object object = this.mux;
        synchronized (object) {
            this.storage.remove(key);
            this.watcher.notify(new Entry(key, null));
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterator<Entry> range(@NotNull ByteArray fromKey, @NotNull ByteArray toKey) {
        Object object = this.mux;
        synchronized (object) {
            ArrayList<Entry> res = new ArrayList<Entry>();
            for (Map.Entry<ByteArray, byte[]> e : this.storage.subMap(fromKey, toKey).entrySet()) {
                res.add(new Entry(new ByteArray(e.getKey().bytes()), (byte[])e.getValue().clone()));
            }
            return res.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Long> watch(@NotNull VaultWatch vaultWatch) {
        Object object = this.mux;
        synchronized (object) {
            return this.watcher.register(vaultWatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> stopWatch(@NotNull Long id) {
        Object object = this.mux;
        synchronized (object) {
            this.watcher.cancel(id);
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> putAll(@NotNull Map<ByteArray, byte[]> vals) {
        Object object = this.mux;
        synchronized (object) {
            vals.forEach((k, v) -> {
                if (v == null) {
                    this.storage.remove(k);
                }
            });
            this.storage.putAll(vals.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }
    }
}

