/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault.common;

import java.util.Collections;
import java.util.Comparator;
import org.apache.ignite.internal.vault.common.Entry;
import org.apache.ignite.internal.vault.common.VaultListener;
import org.apache.ignite.lang.ByteArray;

public final class VaultWatch {
    private static final Comparator<ByteArray> CMP = ByteArray::compare;
    private final ByteArray startKey;
    private final ByteArray endKey;
    private VaultListener listener;

    public VaultWatch(ByteArray startKey, ByteArray endkey, VaultListener listener) {
        this.startKey = startKey;
        this.endKey = endkey;
        this.listener = listener;
    }

    public boolean notify(Entry val) {
        if (this.startKey != null && CMP.compare(val.key(), this.startKey) < 0) {
            return true;
        }
        if (this.endKey != null && CMP.compare(val.key(), this.endKey) >= 0) {
            return true;
        }
        return this.listener.onUpdate(Collections.singleton(val));
    }

    public void onError(Throwable e) {
        this.listener.onError(e);
    }
}

