/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.vault.common.Entry;
import org.apache.ignite.internal.vault.common.VaultWatch;
import org.apache.ignite.internal.vault.service.VaultService;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultManager {
    private static ByteArray APPLIED_REV = ByteArray.fromString((String)"applied_revision");
    private static final ByteArray NODE_NAME = ByteArray.fromString((String)"node_name");
    private final Object mux = new Object();
    private VaultService vaultService;

    public VaultManager(VaultService vaultService) {
        this.vaultService = vaultService;
    }

    public boolean bootstrapped() {
        return false;
    }

    @NotNull
    public CompletableFuture<Entry> get(@NotNull ByteArray key) {
        return this.vaultService.get(key);
    }

    @NotNull
    public CompletableFuture<Void> put(@NotNull ByteArray key, @NotNull byte[] val) {
        return this.vaultService.put(key, val);
    }

    @NotNull
    public CompletableFuture<Void> remove(@NotNull ByteArray key) {
        return this.vaultService.remove(key);
    }

    @NotNull
    public Iterator<Entry> range(@NotNull ByteArray fromKey, @NotNull ByteArray toKey) {
        return this.vaultService.range(fromKey, toKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Void> putAll(@NotNull Map<ByteArray, byte[]> vals) {
        Object object = this.mux;
        synchronized (object) {
            return this.vaultService.putAll(vals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> putAll(@NotNull Map<ByteArray, byte[]> vals, long revision) throws IgniteInternalCheckedException {
        Object object = this.mux;
        synchronized (object) {
            long appliedRevision;
            byte[] appliedRevBytes;
            try {
                appliedRevBytes = this.vaultService.get(APPLIED_REV).get().value();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IgniteInternalCheckedException("Error occurred when getting applied revision", (Throwable)e);
            }
            long l = appliedRevision = appliedRevBytes != null ? ByteUtils.bytesToLong((byte[])appliedRevBytes, (int)0) : 0L;
            if (revision < appliedRevision) {
                throw new IgniteInternalCheckedException("Inconsistency between applied revision from vault and the current revision");
            }
            HashMap<ByteArray, byte[]> mergedMap = new HashMap<ByteArray, byte[]>(vals);
            mergedMap.put(APPLIED_REV, ByteUtils.longToBytes((long)revision));
            return this.vaultService.putAll(mergedMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Long appliedRevision() throws IgniteInternalCheckedException {
        Object object = this.mux;
        synchronized (object) {
            byte[] appliedRevision;
            try {
                appliedRevision = this.vaultService.get(APPLIED_REV).get().value();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IgniteInternalCheckedException("Error occurred when getting applied revision", (Throwable)e);
            }
            return appliedRevision == null ? 0L : ByteUtils.bytesToLong((byte[])appliedRevision, (int)0);
        }
    }

    @NotNull
    public CompletableFuture<Void> putName(@NotNull String name) {
        return this.put(NODE_NAME, name.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public String name() throws IgniteInternalCheckedException {
        Object object = this.mux;
        synchronized (object) {
            try {
                byte[] nodeName = this.vaultService.get(NODE_NAME).get().value();
                if (nodeName != null) {
                    return new String(nodeName, StandardCharsets.UTF_8);
                }
                return null;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IgniteInternalCheckedException("Error occurred when getting node name", (Throwable)e);
            }
        }
    }

    @NotNull
    public CompletableFuture<Long> watch(@NotNull VaultWatch vaultWatch) {
        return this.vaultService.watch(vaultWatch);
    }

    @NotNull
    public CompletableFuture<Void> stopWatch(@NotNull Long id) {
        return this.vaultService.stopWatch(id);
    }
}

