/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.genetic;

import java.util.Arrays;
import java.util.BitSet;
import java.util.function.Function;
import org.apache.ignite.ml.util.genetic.Chromosome;

public class Population {
    private Chromosome[] chromosomes;
    private BitSet fitnessCalculatedFlags;

    public Population(int size) {
        this.chromosomes = new Chromosome[size];
        this.fitnessCalculatedFlags = new BitSet(size);
    }

    public Chromosome getChromosome(int idx) {
        return this.chromosomes[idx];
    }

    public double calculateFitnessForChromosome(int idx, Function<Chromosome, Double> fitnessFunction) {
        double fitness = fitnessFunction.apply(this.chromosomes[idx]);
        this.chromosomes[idx].setFitness(fitness);
        this.fitnessCalculatedFlags.set(idx);
        return fitness;
    }

    public void calculateFitnessForAll(Function<Chromosome, Double> fitnessFunction) {
        for (int i = 0; i < this.chromosomes.length; ++i) {
            this.calculateFitnessForChromosome(i, fitnessFunction);
        }
    }

    public void setChromosome(int idx, Chromosome chromosome) {
        this.chromosomes[idx] = chromosome;
        if (!Double.isNaN(chromosome.getFitness())) {
            this.fitnessCalculatedFlags.set(idx);
        }
    }

    public Chromosome getChromosome(Integer idx) {
        return this.chromosomes[idx];
    }

    public Chromosome[] selectBestKChromosome(int k) {
        if (this.fitnessCalculatedFlags.cardinality() == this.chromosomes.length) {
            Object[] cp = Arrays.copyOf(this.chromosomes, this.chromosomes.length);
            Arrays.sort(cp);
            return (Chromosome[])Arrays.copyOfRange(cp, cp.length - k, cp.length);
        }
        return null;
    }

    public double getTotalFitness() {
        if (this.fitnessCalculatedFlags.cardinality() == this.chromosomes.length) {
            double totalFitness = 0.0;
            for (int i = 0; i < this.chromosomes.length; ++i) {
                totalFitness += this.chromosomes[i].getFitness().doubleValue();
            }
            return totalFitness;
        }
        return Double.NaN;
    }

    public double getAverageFitness() {
        if (this.fitnessCalculatedFlags.cardinality() == this.chromosomes.length) {
            double totalFitness = 0.0;
            for (int i = 0; i < this.chromosomes.length; ++i) {
                totalFitness += this.chromosomes[i].getFitness().doubleValue();
            }
            return totalFitness / (double)this.chromosomes.length;
        }
        return Double.NaN;
    }

    public int size() {
        return this.chromosomes.length;
    }

    public void setFitness(Integer idx, Double fitness) {
        this.chromosomes[idx].setFitness(fitness);
        this.fitnessCalculatedFlags.set(idx);
    }
}

