/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.primitives.vector;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.util.generators.DataStreamGenerator;
import org.apache.ignite.ml.util.generators.primitives.scalar.RandomProducer;

public interface VectorGenerator
extends Supplier<Vector> {
    default public VectorGenerator map(IgniteFunction<Vector, Vector> mapper) {
        return () -> (Vector)mapper.apply((Vector)this.get());
    }

    default public VectorGenerator filter(IgnitePredicate<Vector> predicate) {
        return () -> {
            Vector v = null;
            while (!predicate.apply((Object)(v = (Vector)this.get()))) {
            }
            return v;
        };
    }

    default public VectorGenerator concat(VectorGenerator other) {
        return () -> VectorUtils.concat((Vector)this.get(), (Vector)other.get());
    }

    default public VectorGenerator concat(RandomProducer producer) {
        return () -> VectorUtils.concat((Vector)this.get(), VectorUtils.of((Double)producer.get()));
    }

    default public VectorGenerator plus(VectorGenerator other) {
        return () -> ((Vector)this.get()).plus((Vector)other.get());
    }

    default public VectorGenerator shuffle() {
        return this.shuffle(System.currentTimeMillis());
    }

    default public VectorGenerator shuffle(Long seed) {
        Random rnd = new Random(seed);
        List shuffledIds = IntStream.range(0, ((Vector)this.get()).size()).boxed().collect(Collectors.toList());
        Collections.shuffle(shuffledIds, rnd);
        return this.map(original -> {
            Vector cp = original.copy();
            for (int to = 0; to < cp.size(); ++to) {
                int from = (Integer)shuffledIds.get(to);
                cp.set(to, original.get(from));
            }
            return cp;
        });
    }

    default public VectorGenerator duplicateRandomFeatures(int increaseSize) {
        return this.duplicateRandomFeatures(increaseSize, System.currentTimeMillis());
    }

    default public VectorGenerator duplicateRandomFeatures(int increaseSize, Long seed) {
        A.ensure((increaseSize > 0 ? 1 : 0) != 0, (String)"increaseSize > 0");
        Random rnd = new Random(seed);
        return this.map(original -> {
            int i;
            double[] values = new double[original.size() + increaseSize];
            for (i = 0; i < original.size(); ++i) {
                values[i] = original.get(i);
            }
            for (i = 0; i < increaseSize; ++i) {
                int rndId = rnd.nextInt(original.size());
                values[original.size() + i] = original.get(rndId);
            }
            return VectorUtils.of(values);
        });
    }

    default public VectorGenerator move(Vector v) {
        return this.map(x -> x.plus(v));
    }

    default public VectorGenerator rotate(double angle) {
        return this.rotate(angle, 0, 1);
    }

    default public VectorGenerator rotate(double angle, int firstComponent, int secondComponent) {
        return this.map(x -> x.copy().set(firstComponent, x.get(firstComponent) * Math.cos(angle) + x.get(secondComponent) * Math.sin(angle)).set(secondComponent, -x.get(firstComponent) * Math.sin(angle) + x.get(secondComponent) * Math.cos(angle)));
    }

    default public VectorGenerator noisify(RandomProducer randomProducer) {
        int vectorSize = ((Vector)this.get()).size();
        return this.plus(randomProducer.vectorize(vectorSize));
    }

    default public DataStreamGenerator asDataStream() {
        final VectorGenerator gen = this;
        return new DataStreamGenerator(){

            @Override
            public Stream<LabeledVector<Double>> labeled() {
                return Stream.generate(gen).map(v -> new LabeledVector<Double>((Vector)v, 0.0));
            }
        };
    }
}

