/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.primitives.scalar;

import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.util.generators.primitives.scalar.RandomProducerWithGenerator;

public class GaussRandomProducer
extends RandomProducerWithGenerator {
    private final double mean;
    private final double variance;

    public GaussRandomProducer() {
        this(0.0, 1.0, System.currentTimeMillis());
    }

    public GaussRandomProducer(long seed) {
        this(0.0, 1.0, seed);
    }

    public GaussRandomProducer(double mean, double variance) {
        this(mean, variance, System.currentTimeMillis());
    }

    public GaussRandomProducer(double mean, double variance, long seed) {
        super(seed);
        A.ensure((variance > 0.0 ? 1 : 0) != 0, (String)"variance > 0");
        this.mean = mean;
        this.variance = variance;
    }

    @Override
    public Double get() {
        return this.mean + this.generator().nextGaussian() * Math.sqrt(this.variance);
    }
}

