/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.primitives.scalar;

import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.util.generators.primitives.scalar.RandomProducerWithGenerator;

public class DiscreteRandomProducer
extends RandomProducerWithGenerator {
    private static final double EPS = 1.0E-5;
    private final double[] probs;
    private final int[] ids;

    public DiscreteRandomProducer(double ... probs) {
        this(System.currentTimeMillis(), probs);
    }

    public DiscreteRandomProducer(long seed, double ... probs) {
        super(seed);
        boolean allElementsAreGEZero = Arrays.stream(probs).allMatch(p -> p >= 0.0);
        boolean sumOfProbsEqOne = Math.abs(Arrays.stream(probs).sum() - 1.0) < 1.0E-5;
        A.ensure((boolean)allElementsAreGEZero, (String)"all elements should be great or equals 0.0");
        A.ensure((boolean)sumOfProbsEqOne, (String)"sum of probs should equal 1.0");
        this.probs = Arrays.copyOf(probs, probs.length);
        this.ids = IntStream.range(0, probs.length).toArray();
        this.sort(this.probs, this.ids, 0, probs.length - 1);
        int i = 0;
        for (int j = probs.length - 1; i < j; ++i, --j) {
            double temp = this.probs[i];
            this.probs[i] = this.probs[j];
            this.probs[j] = temp;
            int idxTmp = this.ids[i];
            this.ids[i] = this.ids[j];
            this.ids[j] = idxTmp;
        }
        for (i = 1; i < this.probs.length; ++i) {
            int n = i;
            this.probs[n] = this.probs[n] + this.probs[i - 1];
        }
    }

    public static DiscreteRandomProducer uniform(int numOfValues) {
        return DiscreteRandomProducer.uniform(numOfValues, System.currentTimeMillis());
    }

    public static DiscreteRandomProducer uniform(int numOfValues, long seed) {
        double[] probs = new double[numOfValues];
        Arrays.fill(probs, 1.0 / (double)numOfValues);
        return new DiscreteRandomProducer(seed, probs);
    }

    public static double[] randomDistribution(int numOfValues) {
        return DiscreteRandomProducer.randomDistribution(numOfValues, System.currentTimeMillis());
    }

    public static double[] randomDistribution(int numOfValues, long seed) {
        A.ensure((numOfValues > 0 ? 1 : 0) != 0, (String)"numberOfValues > 0");
        Random random = new Random(seed);
        long[] rnd = IntStream.range(0, numOfValues).mapToLong(i -> random.nextInt(Integer.MAX_VALUE)).limit(numOfValues).toArray();
        long sum = Arrays.stream(rnd).sum();
        double[] res = new double[numOfValues];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = (double)rnd[i2] / Math.max(1.0, (double)sum);
        }
        return res;
    }

    @Override
    public Double get() {
        double p = this.generator().nextDouble();
        for (int i = 0; i < this.probs.length; ++i) {
            if (!(this.probs[i] > p)) continue;
            return this.ids[i];
        }
        return this.ids[this.probs.length - 1];
    }

    public int getInt() {
        return this.get().intValue();
    }

    public int size() {
        return this.probs.length;
    }

    private void sort(double[] probs, int[] idx, int from, int to) {
        if (from < to) {
            double pivot = probs[(from + to) / 2];
            int i = from;
            int j = to;
            while (i <= j) {
                while (probs[i] < pivot) {
                    ++i;
                }
                while (probs[j] > pivot) {
                    --j;
                }
                if (i > j) continue;
                double tmpFeature = probs[i];
                probs[i] = probs[j];
                probs[j] = tmpFeature;
                int tmpLb = idx[i];
                idx[i] = idx[j];
                idx[j] = tmpLb;
                ++i;
                --j;
            }
            this.sort(probs, idx, from, j);
            this.sort(probs, idx, i, to);
        }
    }
}

