/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.impurity;

import java.io.Serializable;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.tree.TreeFilter;
import org.apache.ignite.ml.tree.data.DecisionTreeData;
import org.apache.ignite.ml.tree.data.TreeDataIndex;
import org.apache.ignite.ml.tree.impurity.ImpurityMeasure;
import org.apache.ignite.ml.tree.impurity.util.StepFunction;

public abstract class ImpurityMeasureCalculator<T extends ImpurityMeasure<T>>
implements Serializable {
    protected final boolean useIdx;

    public ImpurityMeasureCalculator(boolean useIdx) {
        this.useIdx = useIdx;
    }

    public abstract StepFunction<T>[] calculate(DecisionTreeData var1, TreeFilter var2, int var3);

    protected int columnsCount(DecisionTreeData data, TreeDataIndex idx) {
        return this.useIdx ? idx.columnsCount() : data.getFeatures()[0].length;
    }

    protected int rowsCount(DecisionTreeData data, TreeDataIndex idx) {
        return this.useIdx ? idx.rowsCount() : data.getFeatures().length;
    }

    protected double getLabelValue(DecisionTreeData data, TreeDataIndex idx, int featureId, int k) {
        return this.useIdx ? idx.labelInSortedOrder(k, featureId) : data.getLabels()[k];
    }

    protected double getFeatureValue(DecisionTreeData data, TreeDataIndex idx, int featureId, int k) {
        return this.useIdx ? idx.featureInSortedOrder(k, featureId) : data.getFeatures()[k][featureId];
    }

    protected Vector getFeatureValues(DecisionTreeData data, TreeDataIndex idx, int featureId, int k) {
        return VectorUtils.of(this.useIdx ? idx.featuresInSortedOrder(k, featureId) : data.getFeatures()[k]);
    }
}

