/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.trainers;

import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.functions.IgniteFunction;

public class AdaptableDatasetModel<I, O, IW, OW, M extends IgniteModel<IW, OW>>
implements IgniteModel<I, O> {
    private final IgniteFunction<I, IW> before;
    private final IgniteFunction<OW, O> after;
    private final M mdl;

    public AdaptableDatasetModel(IgniteFunction<I, IW> before, M mdl, IgniteFunction<OW, O> after) {
        this.before = before;
        this.after = after;
        this.mdl = mdl;
    }

    @Override
    public O predict(I i) {
        return (O)this.before.andThen(arg_0 -> this.mdl.predict(arg_0)).andThen(this.after).apply(i);
    }

    public <O1> AdaptableDatasetModel<I, O1, IW, OW, M> andThen(IgniteModel<O, O1> after) {
        return new AdaptableDatasetModel<I, O, IW, OW, M>(this.before, this.mdl, i -> after.predict(this.after.apply(i)));
    }

    public <I1> AdaptableDatasetModel<I1, O, IW, OW, M> andBefore(IgniteFunction<I1, I> before) {
        IgniteFunction function = i -> this.before.apply(before.apply(i));
        return new AdaptableDatasetModel<I, O, IW, OW, M>(function, this.mdl, this.after);
    }

    public M innerModel() {
        return this.mdl;
    }

    public <M1 extends IgniteModel<IW, OW>> AdaptableDatasetModel<I, O, IW, OW, M1> withInnerModel(M1 mdl) {
        return new AdaptableDatasetModel<I, O, IW, OW, M1>(this.before, mdl, this.after);
    }
}

