/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures;

import org.apache.ignite.ml.math.exceptions.datastructures.NoLabelVectorException;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.exceptions.math.NoDataException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DenseVector;
import org.apache.ignite.ml.structures.Dataset;
import org.apache.ignite.ml.structures.LabeledVector;

public class LabeledVectorSet<Row extends LabeledVector>
extends Dataset<Row>
implements AutoCloseable {
    public LabeledVectorSet() {
    }

    public LabeledVectorSet(int rowSize, int colSize) {
        this(rowSize, colSize, null);
    }

    public LabeledVectorSet(int rowSize, int colSize, String[] featureNames) {
        super(rowSize, colSize, featureNames);
        this.initializeDataWithLabeledVectors();
    }

    public LabeledVectorSet(Row[] data) {
        super(data);
    }

    private void initializeDataWithLabeledVectors() {
        this.data = new LabeledVector[this.rowSize];
        for (int i = 0; i < this.rowSize; ++i) {
            ((LabeledVector[])this.data)[i] = new LabeledVector<Object>(LabeledVectorSet.emptyVector(this.colSize), null);
        }
    }

    public LabeledVectorSet(Row[] data, int colSize) {
        super(data, colSize);
    }

    public LabeledVectorSet(double[][] mtx, double[] lbs) {
        this(mtx, lbs, null);
    }

    public LabeledVectorSet(double[][] mtx, double[] lbs, String[] featureNames) {
        assert (mtx != null);
        assert (lbs != null);
        if (mtx.length != lbs.length) {
            throw new CardinalityException(lbs.length, mtx.length);
        }
        if (mtx[0] == null) {
            throw new NoDataException("Pass filled array, the first vector is empty");
        }
        this.rowSize = lbs.length;
        this.colSize = mtx[0].length;
        if (featureNames == null) {
            this.generateFeatureNames();
        } else {
            assert (this.colSize == featureNames.length);
            this.convertStringNamesToFeatureMetadata(featureNames);
        }
        this.data = new LabeledVector[this.rowSize];
        for (int i = 0; i < this.rowSize; ++i) {
            ((LabeledVector[])this.data)[i] = new LabeledVector<Double>(LabeledVectorSet.emptyVector(this.colSize), lbs[i]);
            for (int j = 0; j < this.colSize; ++j) {
                try {
                    ((LabeledVector[])this.data)[i].features().set(j, mtx[i][j]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoDataException("No data in given matrix by coordinates (" + i + "," + j + ")");
                }
            }
        }
    }

    public double label(int idx) {
        LabeledVector labeledVector = ((LabeledVector[])this.data)[idx];
        return labeledVector != null ? (Double)labeledVector.label() : Double.NaN;
    }

    public double[] labels() {
        assert (this.data != null);
        assert (((LabeledVector[])this.data).length > 0);
        double[] labels = new double[((LabeledVector[])this.data).length];
        for (int i = 0; i < ((LabeledVector[])this.data).length; ++i) {
            labels[i] = (Double)((LabeledVector[])this.data)[i].label();
        }
        return labels;
    }

    public void setLabel(int idx, double lb) {
        LabeledVector labeledVector = ((LabeledVector[])this.data)[idx];
        if (labeledVector == null) {
            throw new NoLabelVectorException(idx);
        }
        labeledVector.setLabel(lb);
    }

    public static Vector emptyVector(int size) {
        return new DenseVector(size);
    }

    public LabeledVectorSet copy() {
        LabeledVectorSet res = new LabeledVectorSet((LabeledVector[])this.data, this.colSize);
        res.meta = this.meta;
        for (int i = 0; i < this.rowSize; ++i) {
            res.setLabel(i, this.label(i));
        }
        return res;
    }

    @Override
    public void close() throws Exception {
    }
}

