/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;

public class Recall<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = 8128102840736337225L;
    private Double recall = Double.NaN;

    public Recall(L truthLabel, L falseLabel) {
        super(truthLabel, falseLabel);
    }

    public Recall() {
    }

    public Recall<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        this.recall = (double)aggr.getTruePositive() / (double)(aggr.getTruePositive() + aggr.getFalseNegative());
        return this;
    }

    @Override
    public double value() {
        return this.recall;
    }

    @Override
    public MetricName name() {
        return MetricName.RECALL;
    }
}

