/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.evaluator;

import java.util.Map;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;

public class EvaluationResult {
    private static final int DEFAULT_PRECISION = 3;
    private final Map<MetricName, Double> values;

    public EvaluationResult(Map<MetricName, Double> values) {
        this.values = values;
    }

    public double get(MetricName name) {
        return this.values.getOrDefault((Object)name, Double.NaN);
    }

    public double getSingle() {
        A.ensure((this.values.size() == 1 ? 1 : 0) != 0, (String)"getSingle expects only one metric");
        return this.values.values().stream().findFirst().get();
    }

    public Iterable<Map.Entry<MetricName, Double>> getAll() {
        return this.values.entrySet();
    }

    public String toString(int precision) {
        StringBuilder sb = new StringBuilder();
        this.values.forEach((k, v) -> sb.append(String.format("%s = %." + precision + "f\n", k.getPrettyName(), v)));
        return sb.toString();
    }

    public String toString() {
        return this.toString(3);
    }
}

